﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace xmlTools
{
    /// <summary>
    /// This class represents a xmlNumberValue. It supports various dimensions separated by spaces. For example a quaternion: 1 -1 1 -1
    /// It also includes various functions to work with multi dimensional number xml values
    /// </summary>
    public class XmlNumberValue
    {
        public List<double> myValues = new List<double>(); //include all dimensions of the value

        public XmlNumberValue(String myString)
        {
            String[] values = myString.Split(' ');

            foreach (string value in values)
            {
                this.myValues.Add(XmlConvert.ToDouble(value));
            }
        }

        public XmlNumberValue(List<double> myDimensions)
        {
            this.myValues = myDimensions;
        }

        public static XmlNumberValue difference(XmlNumberValue first, XmlNumberValue second)
        {
            List<double> result = new List<double>();

            for (int i = 0; i < first.myValues.Count; i++)
            {
                result.Add(first.myValues[i] - second.myValues[i]);
            }

            return new XmlNumberValue(result);
        }

        public static XmlNumberValue sum(XmlNumberValue first, XmlNumberValue second)
        {
            List<double> result = new List<double>();

            for (int i = 0; i < first.myValues.Count; i++)
            {
                result.Add(first.myValues[i] + second.myValues[i]);
            }

            return new XmlNumberValue(result);
        }

        public override string ToString()
        {
            String result = "";

            for (int i = 0; i < this.myValues.Count - 1; i++)
            {
                result += XmlConvert.ToString(this.myValues[i]) + " ";
            }
            result += XmlConvert.ToString(this.myValues[this.myValues.Count - 1]);

            return result;
        }
    }
}
