package net.oni2.platformtools.applicationinvoker;

import java.io.File;
import java.io.IOException;
import java.util.Vector;

import net.oni2.platformtools.PlatformInformation;
import net.oni2.platformtools.PlatformInformation.Platform;

/**
 * @author Christian Illy
 */
public class Wine {
	private static File winePath = null;
	private static int isInst = -1;

	/**
	 * @return Is Wine installed?
	 */
	public static boolean isInstalled() {
		if (isInst < 0)
			getRuntimeExe();
		return isInst == 1;
	}

	/**
	 * @return path to wine, null if not found or not Linux
	 */
	public static File getRuntimeExe() {
		if (isInst < 0) {
			isInst = 0;
			if (PlatformInformation.getPlatform() == Platform.LINUX) {
				Vector<String> params = new Vector<String>();
				params.add("wine");
				ApplicationInvocationResult res = null;
				try {
					res = ApplicationInvoker.executeAndWait(EExeType.OSBINARY,
							null, new File("which"), params);
				} catch (IOException e) {
					e.printStackTrace();
				} catch (ERuntimeNotInstalledException e) {
					e.printStackTrace();
				}
				if (res != null) {
					if (res.output.size() > 0) {
						if (res.output.get(0).startsWith("/")
								&& res.output.get(0).endsWith("wine")) {
							winePath = new File(res.output.get(0));
							isInst = 1;
						}
					}
				}
			}
		}
		return winePath;
	}
}
