/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.event;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JPopupMenu;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuildResult;
import org.javabuilders.BuilderConfig;
import org.javabuilders.IPropertyList;
import org.javabuilders.Node;
import org.javabuilders.ValueListDefinition;
import org.javabuilders.Values;
import org.javabuilders.handler.AbstractPropertyHandler;
import org.javabuilders.util.BuilderUtils;

public class ComponentMouseListenerHandler
extends AbstractPropertyHandler
implements IPropertyList {
    private static final ComponentMouseListenerHandler singleton = new ComponentMouseListenerHandler();
    private static final List<ValueListDefinition> defs = ValueListDefinition.getCommonEventDefinitions((Class[])new Class[]{MouseEvent.class});

    public static ComponentMouseListenerHandler getInstance() {
        return singleton;
    }

    public ComponentMouseListenerHandler() {
        super(new String[]{"onMouseClicked", "onMouseDoubleClicked", "onMouseRightClicked", "onMouseEntered", "onMouseExited", "onMousePressed", "onMouseReleased", "popupMenu"});
    }

    public void handle(BuilderConfig config, final BuildProcess process, final Node node, String key) throws BuildException {
        final Values onMouseClicked = (Values)node.getProperty(new String[]{"onMouseClicked"});
        final Values onMouseDoubleClicked = (Values)node.getProperty(new String[]{"onMouseDoubleClicked"});
        final Values onMouseEntered = (Values)node.getProperty(new String[]{"onMouseEntered"});
        final Values onMouseExited = (Values)node.getProperty(new String[]{"onMouseExited"});
        final Values onMousePressed = (Values)node.getProperty(new String[]{"onMousePressed"});
        final Values onMouseReleased = (Values)node.getProperty(new String[]{"onMouseReleased"});
        final Values onMouseRightClicked = (Values)node.getProperty(new String[]{"onMouseRightClicked"});
        final String popupMenu = node.getStringProperty(new String[]{"popupMenu"});
        if (popupMenu != null) {
            Object menu = process.getBuildResult().get((Object)popupMenu);
            if (menu == null) {
                throw new BuildException("Unable to find an instance of JPopupMenu for {0}", new Object[]{popupMenu});
            }
            if (!(menu instanceof JPopupMenu)) {
                throw new BuildException("Unable to find an instance of JPopupMenu for {0}: {0} is of type {1} instead", new Object[]{popupMenu, menu.getClass()});
            }
        }
        final Component component = (Component)node.getMainObject();
        component.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    if (e.getClickCount() == 2) {
                        if (onMouseDoubleClicked != null) {
                            BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Node)node, (Collection)onMouseDoubleClicked.values(), (Object)e);
                        }
                    } else if (onMouseClicked != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Node)node, (Collection)onMouseClicked.values(), (Object)e);
                    }
                } else if (e.getButton() == 3 && onMouseRightClicked != null) {
                    BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Node)node, (Collection)onMouseRightClicked.values(), (Object)e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (onMouseEntered != null) {
                    BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Node)node, (Collection)onMouseEntered.values(), (Object)e);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (onMouseExited != null) {
                    BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Node)node, (Collection)onMouseExited.values(), (Object)e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (onMousePressed != null) {
                    BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Node)node, (Collection)onMousePressed.values(), (Object)e);
                }
                if (e.isPopupTrigger()) {
                    ComponentMouseListenerHandler.this.showPopup(process.getBuildResult(), component, e, popupMenu);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (onMouseReleased != null) {
                    BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Node)node, (Collection)onMouseReleased.values(), (Object)e);
                }
                if (e.isPopupTrigger()) {
                    ComponentMouseListenerHandler.this.showPopup(process.getBuildResult(), component, e, popupMenu);
                }
            }
        });
    }

    private void showPopup(BuildResult result, Component component, MouseEvent e, String popupMenu) {
        if (popupMenu != null) {
            Object menu = result.get((Object)popupMenu);
            if (menu instanceof JPopupMenu) {
                ((JPopupMenu)menu).show(component, e.getX(), e.getY());
            } else {
                throw new BuildException("Unable to find JPopupMenu corresponding to: {0}", new Object[]{popupMenu});
            }
        }
    }

    public Class<?> getApplicableClass() {
        return Component.class;
    }

    public boolean isList(String propertyName) {
        return !"popupMenu".equals(propertyName);
    }

    public List<ValueListDefinition> getValueListDefinitions(String propertyName) {
        return defs;
    }
}

