/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.javabuilders.BuildException;
import org.javabuilders.BuilderConfig;
import org.javabuilders.IResourceFallback;
import org.javabuilders.event.BackgroundEventListener;
import org.javabuilders.handler.validation.BuilderValidators;
import org.javabuilders.handler.validation.IValidationMessageHandler;
import org.javabuilders.handler.validation.ValidationMessageList;
import org.javabuilders.util.BuilderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildResult
extends HashMap<String, Object> {
    private static final Logger logger = LoggerFactory.getLogger(BuildResult.class);
    private BuilderConfig config;
    private Object caller = null;
    private ResourceBundle defaultBundle = null;
    private List<Object> roots = new ArrayList<Object>();
    private boolean isDirty = false;
    private BuilderValidators validators = new BuilderValidators(this);
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private IValidationMessageHandler validationMessageHandler;
    private Set<ResourceBundle> resourceBundles = new HashSet<ResourceBundle>();
    private Map<String, Field> allFields = null;
    private Object bindingContext = null;
    private Map<String, ?> properties = new HashMap();
    private Set<BackgroundEventListener> backgroundEventListeners = new LinkedHashSet<BackgroundEventListener>();
    private IResourceFallback defaultResourceFallback = new IResourceFallback(){

        @Override
        public String get(String key) {
            if (BuildResult.this.config.getResourceBundles().size() > 0 || BuildResult.this.getResourceBundles().size() > 0) {
                return BuildResult.this.getInvalidResource(key);
            }
            return key;
        }
    };

    public BuildResult(BuilderConfig config, Object caller) {
        this.config = config;
        this.caller = caller;
        this.allFields = BuilderUtils.getAllFields(caller.getClass());
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new BuildException("Null keys are not allowed in BuildResult: {0}", value);
        }
        if (this.keySet().contains(key)) {
            throw new BuildException("Duplicate name \"{0}\" specified in YAML file : {1}", key, value.getClass().getSimpleName());
        }
        return super.put(key, value);
    }

    @Override
    public Object get(Object key) {
        Object value = super.get(key);
        if (value == null && this.allFields.containsKey(key)) {
            Field field = this.allFields.get(key);
            try {
                value = field.get(this.caller);
            }
            catch (Exception e) {
                logger.error("Unable to access field {}: {}", key, (Object)e.getMessage());
            }
        }
        return value;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(propertyName, listener);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(propertyName, listener);
    }

    public void setDirty(boolean isDirty) {
        boolean oldValue = this.isDirty;
        this.isDirty = isDirty;
        this.support.firePropertyChange("dirty", oldValue, isDirty);
    }

    public void sync() throws BuildException {
    }

    public boolean validate() {
        return this.validate(true);
    }

    public boolean validate(boolean handleValidationMessages) {
        ValidationMessageList list = this.getValidationMessages();
        if (list.size() > 0) {
            if (handleValidationMessages) {
                this.validationMessageHandler.handleValidationMessages(list, this);
            }
            return false;
        }
        return true;
    }

    public ValidationMessageList getValidationMessages() {
        return this.getValidators().getValidationMessages(this.validationMessageHandler);
    }

    public BuilderValidators getValidators() {
        return this.validators;
    }

    public IValidationMessageHandler getValidationMessageHandler() {
        return this.validationMessageHandler;
    }

    public void setValidationMessageHandler(IValidationMessageHandler validationMessageHandler) {
        this.validationMessageHandler = validationMessageHandler;
    }

    public Set<ResourceBundle> getResourceBundles() {
        return this.resourceBundles;
    }

    void setResourceBundles(Set<ResourceBundle> bundles) {
        this.resourceBundles = bundles;
    }

    public String getResource(String key) {
        return this.getResource(key, this.defaultResourceFallback);
    }

    public String getResource(String key, IResourceFallback resourceFallback) {
        String bundleKey;
        Enumeration<String> en;
        String resource = null;
        block2: for (ResourceBundle bundle : this.getResourceBundles()) {
            en = bundle.getKeys();
            while (en.hasMoreElements()) {
                bundleKey = en.nextElement();
                if (!key.equals(bundleKey)) continue;
                resource = bundle.getString(key);
                continue block2;
            }
        }
        if (resource == null) {
            block4: for (ResourceBundle bundle : this.config.getResourceBundles()) {
                en = bundle.getKeys();
                while (en.hasMoreElements()) {
                    bundleKey = en.nextElement();
                    if (!key.equals(bundleKey)) continue;
                    resource = bundle.getString(key);
                    continue block4;
                }
            }
        }
        if (resource == null) {
            try {
                if (this.defaultBundle == null) {
                    this.defaultBundle = ResourceBundle.getBundle("org/javabuilders/Resources");
                }
                resource = this.defaultBundle.getString(key);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (resource == null) {
            resource = resourceFallback.get(key);
        }
        return resource;
    }

    public String getInvalidResource(String key) {
        String resource;
        String string = resource = this.config.isMarkInvalidResourceBundleKeys() ? String.format("#%s#", key) : key;
        if (logger.isInfoEnabled()) {
            logger.info("Unable to find value in any resource bundle for key: {}", (Object)key);
        }
        return resource;
    }

    public Object getCaller() {
        return this.caller;
    }

    public BuilderConfig getConfig() {
        return this.config;
    }

    public Object getRoot() {
        if (this.roots.size() > 0) {
            return this.roots.get(0);
        }
        return null;
    }

    public List<Object> getRoots() {
        return this.roots;
    }

    public Object getBindingContext() {
        return this.bindingContext;
    }

    public void setBindingContext(Object bindingContext) {
        this.bindingContext = bindingContext;
    }

    public Map getProperties() {
        return this.properties;
    }

    public boolean isInternationalizationActive() {
        return this.getConfig().getResourceBundles().size() > 0 || this.getResourceBundles().size() > 0;
    }

    public void addBackgroundEventListener(BackgroundEventListener listener) {
        this.backgroundEventListeners.add(listener);
    }

    public void removeBackgroundEventListener(BackgroundEventListener listener) {
        if (this.backgroundEventListeners.contains(listener)) {
            this.backgroundEventListeners.remove(listener);
        }
    }

    public BackgroundEventListener[] getBackgroundEventListeners() {
        return this.backgroundEventListeners.toArray(new BackgroundEventListener[this.backgroundEventListeners.size()]);
    }
}

