/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.property;

import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.IAllowedValues;
import org.javabuilders.Node;
import org.javabuilders.handler.AbstractPropertyHandler;
import org.javabuilders.util.BuilderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameExtendedStateHandler
extends AbstractPropertyHandler
implements IAllowedValues {
    public static final String STATE = "state";
    public static final String ICON = "icon";
    public static final String MAXH = "maxh";
    public static final String MAXV = "maxv";
    public static final String MAX = "max";
    private static final Logger logger = LoggerFactory.getLogger(FrameExtendedStateHandler.class);
    private static final FrameExtendedStateHandler singleton = new FrameExtendedStateHandler();
    private Map<String, Integer> values = new HashMap<String, Integer>();

    public static FrameExtendedStateHandler getInstance() {
        return singleton;
    }

    private FrameExtendedStateHandler() {
        super(new String[]{STATE});
        this.values.put("normal", 0);
        this.values.put("iconified", 1);
        this.values.put("maximized_horiz", 2);
        this.values.put("maximized_vert", 4);
        this.values.put("maximized_both", 6);
        this.values.put(ICON, 1);
        this.values.put(MAXH, 2);
        this.values.put(MAXV, 4);
        this.values.put(MAX, 6);
    }

    public void handle(BuilderConfig config, BuildProcess result, Node node, String key) throws BuildException {
        Frame frame = (Frame)node.getMainObject();
        String value = node.getStringProperty(new String[]{key});
        Integer state = this.values.get(value);
        frame.setExtendedState(state);
        if (BuilderUtils.getOS() == BuilderUtils.OperatingSystem.LinuxUnix) {
            if (logger.isDebugEnabled()) {
                logger.debug("Due to OS-specific Swing bug, handling manually Frame.extendedState: " + state);
            }
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Rectangle screenRect = ge.getMaximumWindowBounds();
            switch (state) {
                case 6: {
                    frame.setSize(screenRect.width, screenRect.width);
                    break;
                }
                case 2: {
                    frame.pack();
                    frame.setSize(screenRect.width, frame.getHeight());
                    break;
                }
                case 4: {
                    frame.pack();
                    frame.setSize(frame.getWidth(), screenRect.height);
                }
            }
        }
    }

    public Class<?> getApplicableClass() {
        return Frame.class;
    }

    public Collection<String> getAllowedValues() {
        return this.values.keySet();
    }
}

