/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler.validation.validator;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.javabuilders.BuildResult;
import org.javabuilders.NamedObjectProperty;
import org.javabuilders.handler.validation.ValidationMessage;
import org.javabuilders.handler.validation.ValidationMessageList;
import org.javabuilders.handler.validation.validator.AbstractValidator;

public class DateFormatValidator
extends AbstractValidator {
    private String dateFormat;
    private Locale locale;

    public DateFormatValidator(NamedObjectProperty property, String label, String messageFormat, BuildResult result, String dateFormat, Locale locale) {
        super(property, label, messageFormat, result);
        this.dateFormat = dateFormat;
        this.locale = locale;
    }

    @Override
    public void validate(Object value, ValidationMessageList list) {
        String sValue = this.getStringValue(value);
        SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat, this.locale);
        try {
            Date date = sdf.parse(sValue);
            if (!sdf.format(date).equals(sValue)) {
                list.add(new ValidationMessage(this.getProperty(), this.getMessage(this.getLabel(), this.dateFormat)));
            }
        }
        catch (ParseException ex) {
            list.add(new ValidationMessage(this.getProperty(), this.getMessage(this.getLabel(), this.dateFormat)));
        }
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

