/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.event;

import java.util.Collection;
import java.util.List;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuildResult;
import org.javabuilders.BuilderConfig;
import org.javabuilders.IPropertyList;
import org.javabuilders.Node;
import org.javabuilders.ValueListDefinition;
import org.javabuilders.Values;
import org.javabuilders.handler.AbstractPropertyHandler;
import org.javabuilders.util.BuilderUtils;

public class JListSelectionListenerHandler
extends AbstractPropertyHandler
implements IPropertyList {
    private static final String ON_SELECTION = "onSelection";
    private static final List<ValueListDefinition> defs = ValueListDefinition.getCommonEventDefinitions((Class[])new Class[]{ListSelectionEvent.class});
    private static final JListSelectionListenerHandler singleton = new JListSelectionListenerHandler();

    public static JListSelectionListenerHandler getInstance() {
        return singleton;
    }

    public JListSelectionListenerHandler() {
        super(new String[]{ON_SELECTION});
    }

    public void handle(BuilderConfig config, final BuildProcess process, Node node, String key) throws BuildException {
        final JList target = (JList)node.getMainObject();
        final Values values = (Values)node.getProperty(new String[]{key});
        if (values.size() > 0) {
            target.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)target, (Collection)values.values(), (Object)e);
                    }
                }
            });
        }
    }

    public List<ValueListDefinition> getValueListDefinitions(String propertyName) {
        return defs;
    }

    public boolean isList(String propertyName) {
        return true;
    }
}

