/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.javabuilders.BuildException;
import org.javabuilders.BuildResult;
import org.javabuilders.BuilderConfig;
import org.javabuilders.NamedObjectPropertyValue;

public class BuildProcess {
    private BuildResult result;
    private Map<String, Object> instances = new HashMap<String, Object>();
    private List<NamedObjectPropertyValue> propertiesAsNamedObjects = new ArrayList<NamedObjectPropertyValue>();
    private BuilderConfig config = null;
    private Object document = null;

    public BuildProcess(BuilderConfig config, Object caller, ResourceBundle ... bundles) throws BuildException {
        if (caller == null) {
            throw new BuildException("Caller cannot be null", new Object[0]);
        }
        if (config == null) {
            throw new BuildException("config cannot be null", new Object[0]);
        }
        this.config = config;
        this.result = new BuildResult(config, caller);
        this.getBuildResult().setValidationMessageHandler(config.getValidationMessageHandler());
        try {
            this.addNamedObject("this", caller);
        }
        catch (BuildException e) {
            // empty catch block
        }
        this.result.getResourceBundles().addAll(Arrays.asList(bundles));
    }

    public Object getByName(String name) {
        return this.result.get(name);
    }

    public BuildResult getBuildResult() {
        return this.result;
    }

    void addNamedObject(String name, Object object) throws BuildException {
        if ("this".equals(name) && this.result.containsKey("this")) {
            throw new BuildException("A named object canot be called 'this', as it is a reserved keyword", new Object[0]);
        }
        if (name != null) {
            try {
                this.result.put(name, object);
            }
            catch (BuildException ex) {
                throw new BuildException(ex, "{0} : {1}", this.getCaller(), ex.getMessage());
            }
        }
    }

    public Object getCaller() {
        return this.getBuildResult().getCaller();
    }

    public Set<ResourceBundle> getResourceBundles() {
        return this.result.getResourceBundles();
    }

    public Map<String, Object> getInstances() {
        return this.instances;
    }

    public List<NamedObjectPropertyValue> getPropertiesAsNamedObjects() {
        return this.propertiesAsNamedObjects;
    }

    public BuilderConfig getConfig() {
        return this.config;
    }

    public Object getDocument() {
        return this.document;
    }

    public void setDocument(Object document) {
        this.document = document;
    }
}

