/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders;

import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.util.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedObjectPropertyValue {
    private static final Logger logger = LoggerFactory.getLogger(NamedObjectPropertyValue.class);
    private Object source = null;
    private String propertyName = null;
    private String targetObjectName = null;

    public NamedObjectPropertyValue(Object source, String propertyName, String targetObjectName) {
        this.source = source;
        this.propertyName = propertyName;
        this.targetObjectName = targetObjectName;
    }

    void setReference(BuildProcess result) throws BuildException {
        Object namedObject = result.getByName(this.targetObjectName);
        if (namedObject == null) {
            throw new BuildException(this.targetObjectName + " is not a valid named object", new Object[0]);
        }
        try {
            PropertyUtils.setProperty(this.source, this.propertyName, namedObject);
        }
        catch (Exception e) {
            throw new BuildException(e, "Unable to set property {0}.{1} to named object \"{2}\"", this.source.getClass().getSimpleName(), this.propertyName, this.targetObjectName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Set reference on property {} to {}", (Object)this.propertyName, (Object)this.targetObjectName);
        }
    }
}

