/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler.binding;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.NamedObjectProperty;
import org.javabuilders.Node;
import org.javabuilders.handler.AbstractTypeHandler;
import org.javabuilders.handler.ITypeChildrenHandler;
import org.javabuilders.handler.binding.BindingSourceDefinition;
import org.javabuilders.handler.binding.BuilderBindings;
import org.javabuilders.util.BuilderUtils;

public abstract class AbstractBuilderBindingsHandler
extends AbstractTypeHandler
implements ITypeChildrenHandler {
    public static final String READ = "read";
    public static final String READ_ONCE = "readOnce";
    public static final String READ_WRITE = "readWrite";

    public AbstractBuilderBindingsHandler() {
        super(new String[0]);
    }

    @Override
    public Node createNewInstance(BuilderConfig config, BuildProcess result, Node parent, String key, Map<String, Object> typeDefinition) throws BuildException {
        BuilderBindings instance = new BuilderBindings();
        return this.useExistingInstance(config, result, parent, key, typeDefinition, instance);
    }

    protected Map<NamedObjectProperty, BindingSourceDefinition> getBindingDefinitions(Node node, BuildProcess process) {
        LinkedHashMap<NamedObjectProperty, BindingSourceDefinition> defs = new LinkedHashMap<NamedObjectProperty, BindingSourceDefinition>();
        List content = (List)node.getProperties().get("content");
        for (Object def : content) {
            if (def instanceof Map) {
                Map map = (Map)def;
                for (String target : map.keySet()) {
                    Object expression = map.get(target);
                    List<String> fullExpression = null;
                    if (expression instanceof String) {
                        fullExpression = new ArrayList<String>();
                        fullExpression.add((String)expression);
                        fullExpression.add(READ_WRITE);
                    } else if (expression instanceof List) {
                        fullExpression = (List)expression;
                        if (fullExpression.size() < 1 || fullExpression.size() > 2) {
                            throw new BuildException("Binding definition expression in invalid format: " + expression + ". Must be a list with two elements, first the expression, second the update strategy", new Object[0]);
                        }
                    } else {
                        throw new BuildException("Binding definition expression in invalid format: " + expression, new Object[0]);
                    }
                    String sourcePathText = (String)fullExpression.get(0);
                    List<NamedObjectProperty> sources = BuilderUtils.getParsedPropertyExpression(sourcePathText);
                    HashSet<String> uniqueSourceNames = new HashSet<String>();
                    Object sourceObject = null;
                    String sourceObjectName = null;
                    for (NamedObjectProperty source : sources) {
                        sourceObjectName = source.getName();
                        sourceObject = process.getByName(sourceObjectName);
                        if (sourceObject == null) {
                            throw new BuildException("Binding source path expression does not refer to a known named object: " + source, new Object[0]);
                        }
                        uniqueSourceNames.add(sourceObjectName);
                    }
                    String nameFormat = "%s.";
                    if (uniqueSourceNames.size() != 1) {
                        throw new BuildException("Binding source path expression cannot refer to properties of more than 1 unique named object: {0}.\nRefers to multiple objects: {1}", sourcePathText, uniqueSourceNames);
                    }
                    sourcePathText = sourcePathText.replace(String.format(nameFormat, sourceObjectName), "");
                    List<NamedObjectProperty> targets = BuilderUtils.getParsedPropertyExpression(target);
                    NamedObjectProperty targetProperty = null;
                    Object targetObject = null;
                    if (targets.size() == 1) {
                        targetProperty = targets.get(0);
                        targetObject = process.getByName(targetProperty.getName());
                        if (targetObject == null) {
                            throw new BuildException("Binding target propertyName does not refer to a known named object: " + targetProperty, new Object[0]);
                        }
                    } else {
                        throw new BuildException("Unable to parse target binding expresson. It must be in single 'objectName.propertyName' format. Invalid format: " + target, new Object[0]);
                    }
                    BindingSourceDefinition sourceDef = new BindingSourceDefinition(sourceObject, sourcePathText, (String)fullExpression.get(1));
                    defs.put(targetProperty, sourceDef);
                }
                continue;
            }
            throw new BuildException("Binding definition in invalid format: " + def, new Object[0]);
        }
        return defs;
    }

    @Override
    public final Class<?> getApplicableClass() {
        return BuilderBindings.class;
    }
}

