/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler.type;

import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.Node;
import org.javabuilders.handler.ITypeAsValueHandler;

public final class ClassAsValueHandler
implements ITypeAsValueHandler<Class<?>> {
    private static final String CLASS_VALUE_REGEX = "^(.)+$";
    private static final ClassAsValueHandler SINGLETON = new ClassAsValueHandler();

    public static ClassAsValueHandler getInstance() {
        return SINGLETON;
    }

    @Override
    public String getInputValueSample() {
        return "java.lang.String";
    }

    @Override
    public Class<?> getValue(BuildProcess process, Node node, String key, Object inputValue) throws BuildException {
        String classValue = (String)inputValue;
        if (classValue.matches(CLASS_VALUE_REGEX)) {
            try {
                return Class.forName(classValue);
            }
            catch (ClassNotFoundException e) {
                throw new BuildException("\"{0}\" is not a valid class", classValue);
            }
        }
        throw new BuildException("\"{0}\" is not a valid class", classValue);
    }

    @Override
    public String getRegex() {
        return CLASS_VALUE_REGEX;
    }

    @Override
    public Class<?> getApplicableClass() {
        return Class.class;
    }
}

