/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders;

import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.javabuilders.BuildException;
import org.javabuilders.BuildResult;
import org.javabuilders.ConfigurationException;
import org.javabuilders.DuplicateAliasException;
import org.javabuilders.ICustomCommand;
import org.javabuilders.PrefixControlDefinition;
import org.javabuilders.TypeDefinition;
import org.javabuilders.TypeDefinitionClassHierarchyComparator;
import org.javabuilders.event.BackgroundEventListener;
import org.javabuilders.event.BuildListener;
import org.javabuilders.event.IBackgroundProcessingHandler;
import org.javabuilders.handler.DefaultPropertyHandler;
import org.javabuilders.handler.DefaultTypeHandler;
import org.javabuilders.handler.IPropertyHandler;
import org.javabuilders.handler.ITypeHandler;
import org.javabuilders.handler.IntegerAsValueHandler;
import org.javabuilders.handler.binding.BuilderBindings;
import org.javabuilders.handler.type.ClassAsValueHandler;
import org.javabuilders.handler.type.IntArrayAsValueHandler;
import org.javabuilders.handler.type.IntegerArrayAsValueHandler;
import org.javabuilders.handler.validation.BuilderValidators;
import org.javabuilders.handler.validation.DefaultValidatorTypeHandler;
import org.javabuilders.handler.validation.IValidationMessageHandler;
import org.javabuilders.util.BuilderUtils;
import org.javabuilders.util.PropertyUtils;

public class BuilderConfig {
    private static final Pattern nameExtractor = Pattern.compile(".+\\((?:\\s*|.*,\\s*)name\\s*=\\s*([a-zA-Z0-9_]+)(?:\\s*|,|).*\\).*");
    static ITypeHandler defaultTypeHandler = new DefaultTypeHandler();
    static IPropertyHandler defaultPropertyHandler = DefaultPropertyHandler.getInstance();
    private static String devSourceFolder = null;
    public static final String SOURCE = "javabuilders.dev.src";
    public static final String CUSTOM_COMMAND_REGEX = "\\$[a-zA-Z0-9]+";
    public static final String GLOBAL_VARIABLE_REGEX = "\\$\\$\\{[a-zA-Z0-9]+\\}";
    public static String PROPERY_STRING_LITERAL_CONTROL_PREFIX = "StringLiteralControl.Prefix";
    public static String PROPERY_STRING_LITERAL_CONTROL_SUFFIX = "StringLiteralControl.Suffix";
    private Map<Class<?>, Map<String, IPropertyHandler>> propertyHandlers = new HashMap();
    private Map<Class<?>, TypeDefinition> typeDefinitions = new HashMap();
    private Map<String, Class<?>> typeAliases = new HashMap();
    private boolean markInvalidResourceBundleKeys = false;
    private Map<Class<?>, Set<TypeDefinition>> typeDefinitionsForClassCache = new HashMap();
    private IBackgroundProcessingHandler backgroundProcessingHandler = null;
    private IValidationMessageHandler validationMessageHandler = null;
    private Map<String, ICustomCommand<? extends Object>> customCommands = new HashMap<String, ICustomCommand<? extends Object>>();
    private Set<BuildListener> buildListeners = new LinkedHashSet<BuildListener>();
    private Set<BackgroundEventListener> backgroundEventListeners = new LinkedHashSet<BackgroundEventListener>();
    private Map<String, Object> customProperties = new HashMap<String, Object>();
    private Map<String, Object> globals = new HashMap<String, Object>();
    private String namePropertyName = "name";
    private Map<String, PrefixControlDefinition> prefixes = new HashMap<String, PrefixControlDefinition>();
    private Map<String, String> prototypes = new HashMap<String, String>();
    private Set<ResourceBundle> bundles = new LinkedHashSet<ResourceBundle>();
    private String yamlExtension = ".yml";

    public static String getDevSourceFolder() {
        return devSourceFolder;
    }

    public static void setDevSourceFolder(String devSourceFolder) {
        BuilderConfig.devSourceFolder = devSourceFolder;
    }

    protected Map<Class<?>, Map<String, IPropertyHandler>> getPropertyHandlers() {
        return this.propertyHandlers;
    }

    public BuilderConfig(IBackgroundProcessingHandler backgroundProcessingHandler, IValidationMessageHandler validationMessageHandler, ICustomCommand<Boolean> confirmCommand) {
        this.backgroundProcessingHandler = backgroundProcessingHandler;
        this.validationMessageHandler = validationMessageHandler;
        this.customCommands.put("$confirm", confirmCommand);
        this.addType("bind", BuilderBindings.class);
        this.addType("validate", BuilderValidators.class);
        this.forType(Class.class).valueHandler(ClassAsValueHandler.getInstance());
        this.forType(BuilderValidators.class).typeHandler(DefaultValidatorTypeHandler.getInstance());
        this.forType(Integer.TYPE).valueHandler(IntegerAsValueHandler.getInstance());
        this.forType(int[].class).valueHandler(IntArrayAsValueHandler.getInstance());
        this.forType(Integer[].class).valueHandler(IntegerArrayAsValueHandler.getInstance());
        this.addCustomCommand("$validate", new ICustomCommand<Boolean>(){

            @Override
            public Boolean process(BuildResult result, Object source) {
                return result.validate();
            }
        });
    }

    public TypeDefinition forType(Class<?> applicableClass) {
        if (applicableClass == null) {
            throw new NullPointerException("applicableClass cannot be null");
        }
        TypeDefinition def = null;
        if (this.typeDefinitions.containsKey(applicableClass)) {
            def = this.typeDefinitions.get(applicableClass);
        } else {
            def = new TypeDefinition(applicableClass);
            this.typeDefinitions.put(applicableClass, def);
            this.typeDefinitionsForClassCache.clear();
        }
        return def;
    }

    public BuilderConfig addType(Class<?> ... classTypes) {
        for (Class<?> type : classTypes) {
            this.addType(type);
        }
        return this;
    }

    public BuilderConfig addType(Class<?> classType) {
        this.addType(classType.getSimpleName(), classType);
        return this;
    }

    public BuilderConfig addType(String alias, Class<?> classType) {
        if (alias == null || alias.length() == 0) {
            throw new NullPointerException("alias cannot be null or empty");
        }
        if (classType == null) {
            throw new NullPointerException("classType cannot be null");
        }
        if (this.typeAliases.containsKey(alias)) {
            String error = String.format("Duplicate alias '%s' for class '%s'. One already exists for '%s'", alias, classType.getName(), this.typeAliases.get(alias).getName());
            throw new DuplicateAliasException(error);
        }
        this.typeAliases.put(alias, classType);
        return this;
    }

    public BuilderConfig removeType(Class<?> classType) {
        ArrayList<String> keys = new ArrayList<String>();
        for (String alias : this.typeAliases.keySet()) {
            Class<?> type = this.typeAliases.get(alias);
            if (type != classType) continue;
            keys.add(alias);
        }
        for (String key : keys) {
            this.typeAliases.remove(key);
        }
        return this;
    }

    public Collection<TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions.values();
    }

    public TypeDefinition getTypeDefinition(Class<?> classType) {
        return this.typeDefinitions.get(classType);
    }

    public Set<TypeDefinition> getTypeDefinitions(Class<?> classType) {
        if (classType == null) {
            throw new NullPointerException("classType cannot be null");
        }
        Set<TypeDefinition> defs = null;
        if (this.typeDefinitionsForClassCache.containsKey(classType)) {
            defs = this.typeDefinitionsForClassCache.get(classType);
        } else {
            Class superClass;
            defs = new TreeSet<Object>(new TypeDefinitionClassHierarchyComparator());
            HashSet interfaces = new HashSet();
            for (superClass = classType; superClass != null; superClass = superClass.getSuperclass()) {
                interfaces.addAll(Arrays.asList(superClass.getInterfaces()));
                if (!this.typeDefinitions.containsKey(superClass)) continue;
                defs.add(this.typeDefinitions.get(superClass));
            }
            Iterator i$ = interfaces.iterator();
            while (i$.hasNext()) {
                Class interfaceType;
                for (superClass = interfaceType = (Class)i$.next(); superClass != null; superClass = superClass.getSuperclass()) {
                    if (!this.typeDefinitions.containsKey(superClass)) continue;
                    defs.add(this.typeDefinitions.get(superClass));
                }
            }
            this.typeDefinitionsForClassCache.put(classType, defs);
        }
        return defs;
    }

    public boolean isTypeDefined(Class<?> classType) {
        return this.typeDefinitions.containsKey(classType);
    }

    public Class<?> getClassType(String alias) {
        Class<?> classType = this.typeAliases.get(alias);
        return classType;
    }

    public String getNameIfAvailable(Map<String, Object> data) {
        String name = (String)data.get(this.namePropertyName);
        return name;
    }

    public String getObjectName(Object instance) throws ConfigurationException {
        String name = null;
        try {
            Object value = PropertyUtils.getProperty(instance, this.namePropertyName);
            if (value != null) {
                name = String.valueOf(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    public void setNamePropertyName(String namePropertyName) {
        this.namePropertyName = namePropertyName;
    }

    public String getNamePropertyName() {
        return this.namePropertyName;
    }

    public boolean isMarkInvalidResourceBundleKeys() {
        return this.markInvalidResourceBundleKeys;
    }

    public void setMarkInvalidResourceBundleKeys(boolean markInvalidResourceBundleKeys) {
        this.markInvalidResourceBundleKeys = markInvalidResourceBundleKeys;
    }

    public IBackgroundProcessingHandler getBackgroundProcessingHandler() {
        return this.backgroundProcessingHandler;
    }

    public void setBackgroundProcessingHandler(IBackgroundProcessingHandler backgroundProcessingHandler) {
        this.backgroundProcessingHandler = backgroundProcessingHandler;
    }

    public IValidationMessageHandler getValidationMessageHandler() {
        return this.validationMessageHandler;
    }

    public void setValidationMessageHandler(IValidationMessageHandler validationMessageHandler) {
        this.validationMessageHandler = validationMessageHandler;
    }

    public BuilderConfig addCustomCommand(String globalName, ICustomCommand<Boolean> command) {
        BuilderUtils.validateNotNullAndNotEmpty("globalName", globalName);
        BuilderUtils.validateNotNullAndNotEmpty("command", command);
        if (globalName.matches(CUSTOM_COMMAND_REGEX)) {
            if (this.customCommands.containsKey(globalName)) {
                throw new BuildException("A custom command with the global name " + globalName + " is already defined", new Object[0]);
            }
        } else {
            throw new BuildException(globalName + " is not a valid custom command name. Must start with '$'", new Object[0]);
        }
        this.customCommands.put(globalName, command);
        return this;
    }

    public Map<String, ICustomCommand<? extends Object>> getCustomCommands() {
        return this.customCommands;
    }

    public Set<ResourceBundle> getResourceBundles() {
        return this.bundles;
    }

    public String getResource(String key) {
        String value = null;
        for (ResourceBundle bundle : this.getResourceBundles()) {
            if (!bundle.containsKey(key)) continue;
            value = bundle.getString(key);
            break;
        }
        return value;
    }

    public void addResourceBundle(String resourceBundleName) {
        this.getResourceBundles().add(ResourceBundle.getBundle(resourceBundleName));
    }

    public void addResourceBundle(ResourceBundle resourceBundle) {
        this.getResourceBundles().add(resourceBundle);
    }

    public void addBuildListener(BuildListener listener) {
        this.buildListeners.add(listener);
    }

    public void removeBuildListener(BuildListener listener) {
        if (this.buildListeners.contains(listener)) {
            this.buildListeners.remove(listener);
        }
    }

    public BuildListener[] getBuildListeners() {
        return this.buildListeners.toArray(new BuildListener[this.buildListeners.size()]);
    }

    public void addBackgroundEventListener(BackgroundEventListener listener) {
        this.backgroundEventListeners.add(listener);
    }

    public void removeBackgroundEventListener(BackgroundEventListener listener) {
        if (this.backgroundEventListeners.contains(listener)) {
            this.backgroundEventListeners.remove(listener);
        }
    }

    public BackgroundEventListener[] getBackgroundEventListeners() {
        return this.backgroundEventListeners.toArray(new BackgroundEventListener[this.backgroundEventListeners.size()]);
    }

    public Map<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public PropertyChangeSupport createPropertyChangeSupport(Object source) {
        return new PropertyChangeSupport(source);
    }

    public BuilderConfig addGlobalVariable(String name, Object value) {
        BuilderUtils.validateNotNullAndNotEmpty("name", name);
        BuilderUtils.validateNotNullAndNotEmpty("value", value);
        if (name.matches(GLOBAL_VARIABLE_REGEX)) {
            if (this.globals.containsKey(this.globals)) {
                throw new BuildException("A global variable {0} already exists", name);
            }
        } else {
            throw new BuildException("{0} is not a valid global variable. Must start with '$'", name);
        }
        this.globals.put(name, value);
        return this;
    }

    public Object getGlobalVariable(String name, Class<?> expectedType) {
        BuilderUtils.validateNotNullAndNotEmpty("name", name);
        BuilderUtils.validateNotNullAndNotEmpty("expectedType", expectedType);
        Object value = this.globals.get(name);
        if (value == null) {
            throw new BuildException("Global variable {0} is null", name);
        }
        if (!expectedType.isAssignableFrom(value.getClass())) {
            throw new BuildException("Global variable {0} is not compatible with expected type {1}", name, expectedType);
        }
        return value;
    }

    public BuilderConfig addTypeHandler(ITypeHandler typeHandler) {
        this.forType(typeHandler.getApplicableClass()).typeHandler(typeHandler);
        return this;
    }

    public ITypeHandler getTypeHandler(Class<?> classType) {
        return TypeDefinition.getTypeHandler(this, classType);
    }

    public BuilderConfig addPropertyHandler(Class<?> type, IPropertyHandler handler) {
        this.forType(type).propertyHandler(handler);
        return this;
    }

    public IPropertyHandler getPropertyHandler(Class<?> classType, String key) {
        return TypeDefinition.getPropertyHandler(this, classType, key);
    }

    public void prefix(String prefix, Class<?> clazz) {
        this.prefix(prefix, clazz, null);
    }

    public void prefix(String prefix, Class<?> clazz, Map<String, String> defaults) {
        PrefixControlDefinition def = new PrefixControlDefinition();
        def.setType(clazz);
        def.setDefaults(defaults);
        this.prefixes.put(prefix, def);
    }

    public PrefixControlDefinition getPrefix(String prefix) {
        return this.prefixes.get(prefix);
    }

    public String prototype(String yaml) {
        Matcher m = nameExtractor.matcher(yaml);
        if (m.find() && m.groupCount() >= 1) {
            String name = m.group(1);
            this.prototypes.put(name, yaml);
            return name;
        }
        throw new RuntimeException("Unable to extract 'name' property from YAML: " + yaml);
    }

    public void prototypes(String ... yamls) {
        for (String yaml : yamls) {
            this.prototype(yaml);
        }
    }

    public String getPrototype(String name) {
        return this.prototypes.get(name);
    }

    public String getYamlExtension() {
        return this.yamlExtension;
    }

    public void setYamlExtension(String yamlExtension) {
        this.yamlExtension = yamlExtension;
    }

    static {
        devSourceFolder = System.getProperty(SOURCE);
    }
}

