/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler.type;

import java.awt.Component;
import java.awt.Font;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.Node;
import org.javabuilders.handler.ITypeAsValueHandler;

public class FontAsValueHandler
implements ITypeAsValueHandler<Font> {
    public static final String REGEX = ".*";
    private static final String REGEX_ITALIC = "italic";
    private static final String REGEX_BOLD = "bold";
    private static final String REGEX_SIZE = "[0-9]{1,3}pt";
    public static final FontAsValueHandler singleton = new FontAsValueHandler();

    private FontAsValueHandler() {
    }

    public static FontAsValueHandler getInstance() {
        return singleton;
    }

    @Override
    public String getInputValueSample() {
        return "italic 12pt Arial";
    }

    @Override
    public String getRegex() {
        return REGEX;
    }

    @Override
    public Font getValue(BuildProcess process, Node node, String key, Object inputValue) throws BuildException {
        String[] parts;
        Font font = null;
        int size = 12;
        String name = "Arial";
        if (node.getMainObject() instanceof Component) {
            Component c = (Component)node.getMainObject();
            size = c.getFont().getSize();
            name = c.getFont().getName();
        }
        boolean italic = false;
        boolean bold = false;
        String sValue = String.valueOf(inputValue);
        for (String part : parts = sValue.split("\\s")) {
            if (part.matches(REGEX_BOLD)) {
                bold = true;
                continue;
            }
            if (part.matches(REGEX_ITALIC)) {
                italic = true;
                continue;
            }
            if (part.matches(REGEX_SIZE)) {
                size = Integer.parseInt(part.substring(0, part.length() - 2));
                continue;
            }
            name = part;
        }
        int style = 0;
        if (italic) {
            style = 2;
        }
        if (bold) {
            style |= 1;
        }
        font = new Font(name, style, size);
        return font;
    }

    @Override
    public Class<?> getApplicableClass() {
        return Font.class;
    }
}

