/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.layout.mig;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.Builder;
import org.javabuilders.BuilderConfig;
import org.javabuilders.IStringLiteralControlConfig;
import org.javabuilders.Node;
import org.javabuilders.TypeDefinition;
import org.javabuilders.handler.AbstractTypeHandler;
import org.javabuilders.handler.ITypeChildrenHandler;
import org.javabuilders.layout.ControlConstraint;
import org.javabuilders.layout.DefaultResize;
import org.javabuilders.layout.Flow;
import org.javabuilders.layout.HAlign;
import org.javabuilders.layout.LayoutCell;
import org.javabuilders.layout.LayoutConstraints;
import org.javabuilders.layout.VAlign;
import org.javabuilders.layout.mig.MigLayoutCommon;
import org.javabuilders.util.BuilderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMigLayoutHandler
extends AbstractTypeHandler
implements ITypeChildrenHandler {
    private static final Map<DefaultResize, String> resizeConstraints = new HashMap<DefaultResize, String>();
    protected static final Logger logger = LoggerFactory.getLogger(AbstractMigLayoutHandler.class);
    private Class<?> defaultTypeClass = null;
    private String defaultTypePropertyName = null;

    protected AbstractMigLayoutHandler(Class<?> defaultTypeClass, String defaultTypePropertyName) {
        super(new String[0]);
        this.defaultTypeClass = defaultTypeClass;
        this.defaultTypePropertyName = defaultTypePropertyName;
    }

    protected abstract void setLayout(BuildProcess var1, Node var2, Object var3) throws BuildException;

    protected abstract Object getComponent(BuildProcess var1, Node var2, String var3) throws BuildException;

    protected abstract void setLayoutConstraints(Object var1, String var2) throws BuildException;

    protected abstract void setRowConstraints(Object var1, String var2) throws BuildException;

    protected abstract void setColumnConstraints(Object var1, String var2) throws BuildException;

    protected abstract void applyControlConstraints(BuildProcess var1, Node var2, Node var3, Map<String, String> var4) throws BuildException;

    protected abstract void setControlName(Object var1, String var2);

    @Override
    public final Node useExistingInstance(BuilderConfig config, BuildProcess process, Node parent, String key, Map<String, Object> typeDefinition, Object instance) throws BuildException {
        Node node = new Node(parent, key, typeDefinition);
        node.setMainObject(instance);
        Node components = parent;
        this.setLayout(process, node, node.getMainObject());
        String layoutCo = "";
        String rowCo = "";
        String columnCo = "";
        LinkedHashMap<String, String> layoutConstraints = new LinkedHashMap<String, String>();
        if (typeDefinition.containsKey("layout")) {
            String visualLayout = String.valueOf(typeDefinition.get("layout"));
            LayoutConstraints lo = LayoutConstraints.getParsedLayoutConstraints(visualLayout, "[] ", "[] ");
            layoutCo = lo.getLayoutConstraints();
            for (String row : lo.getRowConstraints()) {
                rowCo = rowCo + " " + row;
            }
            for (String column : lo.getColumnConstraints()) {
                columnCo = columnCo + " " + column;
            }
            StringBuilder builder = new StringBuilder();
            for (LayoutCell cell : lo.getCells()) {
                boolean firstControl = true;
                for (ControlConstraint co : cell.getControls()) {
                    Object component = this.getNamedComponentOrCreateOne(process, components, co);
                    if (component == null) {
                        throw new BuildException("MigLayout unable to find control named \"{0}\" in layout:\n{1}", co.getControlName(), visualLayout);
                    }
                    builder.setLength(0);
                    builder.append("cell ");
                    builder.append(cell.getColumnIndex());
                    builder.append(" ");
                    builder.append(cell.getRowIndex());
                    if (firstControl) {
                        if (co.getHSpan() > 1 || co.getVSpan() > 1) {
                            builder.append(" ").append(co.getHSpan()).append(" ").append(co.getVSpan());
                        }
                        if (cell.getFlow() == Flow.VERTICAL) {
                            builder.append(", flowy, top");
                        }
                        firstControl = false;
                    }
                    MigLayoutCommon.handleResize(builder, co, TypeDefinition.getDefaultResize(config, component.getClass()), lo.getAdditionalControlConstraints().get(co.getControlName()));
                    if (co.getHAlign() == HAlign.CENTER) {
                        builder.append(", alignx center");
                    } else if (co.getHAlign() == HAlign.RIGHT) {
                        builder.append(", alignx right");
                    } else if (co.getHAlign() == HAlign.LEFT) {
                        builder.append(", alignx left");
                    }
                    if (co.getVAlign() == VAlign.MIDDLE) {
                        builder.append(", aligny center");
                    } else if (co.getVAlign() == VAlign.BOTTOM) {
                        builder.append(", aligny bottom");
                    } else if (co.getVAlign() == VAlign.TOP) {
                        builder.append(", aligny top");
                    }
                    if (co.getSizeGroup() != null) {
                        if (co.isSizeGroupX()) {
                            builder.append(", sgx ").append(co.getSizeGroup());
                        } else if (co.isSizeGroupY()) {
                            builder.append(", sgy ").append(co.getSizeGroup());
                        } else {
                            builder.append(", sg ").append(co.getSizeGroup());
                        }
                    }
                    if (lo.getAdditionalControlConstraints().containsKey(co.getControlName())) {
                        String constraints = lo.getAdditionalControlConstraints().get(co.getControlName());
                        if (constraints.matches("\\$\\$\\{[a-zA-Z0-9]+\\}")) {
                            constraints = (String)config.getGlobalVariable(constraints, String.class);
                        }
                        builder.append(", ").append(constraints);
                    }
                    layoutConstraints.put(co.getControlName(), builder.toString());
                }
            }
        }
        if (typeDefinition.containsKey("layoutConstraints")) {
            layoutCo = layoutCo + " " + typeDefinition.get("layoutConstraints");
        }
        if (typeDefinition.containsKey("rowConstraints")) {
            rowCo = rowCo + " " + typeDefinition.get("rowConstraints");
        }
        if (typeDefinition.containsKey("columnConstraints")) {
            columnCo = columnCo + " " + typeDefinition.get("columnConstraints");
        }
        if (layoutCo.length() > 0) {
            this.setLayoutConstraints(instance, layoutCo);
            if (logger.isDebugEnabled()) {
                logger.debug("MigLayout constraints: " + layoutCo);
            }
        }
        if (rowCo.length() > 0) {
            this.setRowConstraints(instance, rowCo);
            if (logger.isDebugEnabled()) {
                logger.debug("MigLayout row constraints: " + rowCo);
            }
        }
        if (columnCo.length() > 0) {
            this.setColumnConstraints(instance, columnCo);
            if (logger.isDebugEnabled()) {
                logger.debug("MigLayout column constraints: " + columnCo);
            }
        }
        if (typeDefinition.containsKey("constraints")) {
            List constraints = (List)typeDefinition.get("constraints");
            for (Object constraint : constraints) {
                if (constraint instanceof String) {
                    if (layoutConstraints.containsKey(constraint)) continue;
                    layoutConstraints.put(String.valueOf(constraint), "");
                    continue;
                }
                if (!(constraint instanceof Map)) continue;
                Map map = (Map)constraint;
                for (String componentName : map.keySet()) {
                    Object componentConstraint = map.get(componentName);
                    String existingConstraint = (String)layoutConstraints.get(componentName);
                    existingConstraint = existingConstraint == null ? String.valueOf(componentConstraint) : existingConstraint + ", " + String.valueOf(componentConstraint);
                    layoutConstraints.put(componentName, existingConstraint);
                }
            }
        }
        this.applyControlConstraints(process, node, components, layoutConstraints);
        return node;
    }

    @Override
    public String getCollectionPropertyName() {
        return "constraints";
    }

    @Override
    public String getSimpleValuePropertyName() {
        return "layout";
    }

    private Object getNamedComponentOrCreateOne(BuildProcess process, Node components, ControlConstraint co) {
        String name = co.getControlName();
        Object component = this.getComponent(process, components, name);
        if (component == null) {
            if (name.startsWith("\"") && name.endsWith("\"")) {
                String text = name.replace("\"", "");
                text = BuilderUtils.handlePotentialHtmlContent(text);
                text = process.getBuildResult().getResource(text);
                if (name.equals("\"\"")) {
                    name = "blank";
                }
                String prefix = null;
                String suffix = null;
                if (process.getConfig() instanceof IStringLiteralControlConfig) {
                    IStringLiteralControlConfig config = (IStringLiteralControlConfig)((Object)process.getConfig());
                    prefix = config.getStringLiteralControlPrefix();
                    suffix = config.getStringLiteralControlSuffix();
                }
                name = BuilderUtils.generateName(process.getBuildResult(), name, prefix, suffix);
                String compressedYaml = String.format("%s(name=%s,%s=\"%s\")", this.defaultTypeClass.getSimpleName(), name, this.defaultTypePropertyName, text);
                component = Builder.createControlFromCompressedYaml(process, components, compressedYaml);
                co.setControlName(name);
                this.setControlName(component, name);
            } else {
                component = Builder.buildControlFromName(process, components, name);
            }
        }
        return component;
    }

    static {
        resizeConstraints.put(DefaultResize.BOTH, "grow");
        resizeConstraints.put(DefaultResize.X_AXIS, "growx");
        resizeConstraints.put(DefaultResize.Y_AXIS, "growy");
    }
}

