/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.type;

import java.awt.Component;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.Node;
import org.javabuilders.handler.ITypeHandlerFinishProcessor;
import org.javabuilders.swing.IconUtils;

public class JTabbedPaneTypeHandler
implements ITypeHandlerFinishProcessor {
    private static final JTabbedPaneTypeHandler singleton = new JTabbedPaneTypeHandler();
    public static final String TAB_TITLE = "tabTitle";
    public static final String TAB_ICON = "tabIcon";
    public static final String TAB_TOOLTIP = "tabToolTip";
    public static final String TAB_ENABLED = "tabEnabled";

    public static JTabbedPaneTypeHandler getInstance() {
        return singleton;
    }

    public void finish(BuilderConfig config, BuildProcess process, Node current, String key, Map<String, Object> typeDefinition) throws BuildException {
        JTabbedPane tabs = (JTabbedPane)current.getMainObject();
        Node content = current.getChildNode("content");
        if (content != null) {
            current.getCustomProperties().put("ignoreLayoutManager", Boolean.TRUE);
            int tabCounter = 0;
            for (Node child : content.getChildNodes()) {
                ++tabCounter;
                Component c = (Component)child.getMainObject();
                String tabTitle = child.getStringProperty(new String[]{TAB_TITLE});
                if (tabTitle == null && (tabTitle = c.getName()) == null) {
                    tabTitle = String.format("tab%s", tabCounter);
                }
                String tabIcon = child.getStringProperty(new String[]{TAB_ICON});
                Icon icon = null;
                if (tabIcon != null) {
                    icon = IconUtils.getIcon(process, tabIcon);
                }
                String tabTooltip = child.getStringProperty(new String[]{TAB_TOOLTIP});
                tabs.addTab(tabTitle, icon, c, tabTooltip);
                String tabEnabled = child.getStringProperty(new String[]{TAB_ENABLED});
                if (!"false".equals(tabEnabled)) continue;
                tabs.setEnabledAt(tabs.getTabCount() - 1, false);
            }
        }
    }
}

