/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler.validation.validator;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.javabuilders.BuildResult;
import org.javabuilders.NamedObjectProperty;
import org.javabuilders.handler.validation.ValidationMessage;
import org.javabuilders.handler.validation.ValidationMessageList;
import org.javabuilders.handler.validation.validator.AbstractValidator;

public class EmailAddressValidator
extends AbstractValidator {
    private static String REGEX = "[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?";

    public EmailAddressValidator(NamedObjectProperty property, String label, String messageFormat, BuildResult result) {
        super(property, label, messageFormat, result);
    }

    @Override
    public void validate(Object value, ValidationMessageList list) {
        String sValue = this.getStringValue(value);
        if (StringUtils.isNotEmpty((String)sValue) && !Pattern.matches(REGEX, sValue)) {
            list.add(new ValidationMessage(this.getProperty(), this.getMessage(this.getLabel())));
        }
    }
}

