/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.layout;

import java.util.ArrayList;
import java.util.List;
import org.javabuilders.layout.ControlConstraint;
import org.javabuilders.layout.Flow;

public class LayoutCell {
    public static final char SPAN_INDICATOR = '+';
    public static final char MAX_SPAN_VALUE = '*';
    private int columnIndex = 0;
    private int rowIndex = 0;
    private Flow flow = Flow.HORIZONTAL;
    private List<ControlConstraint> controls = new ArrayList<ControlConstraint>();

    public LayoutCell(int rowIndex, int cellIndex) {
        this.rowIndex = rowIndex;
        this.columnIndex = cellIndex;
    }

    public List<ControlConstraint> getControls() {
        return this.controls;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public int getHSpan() {
        if (this.getControls().size() == 0) {
            return 1;
        }
        return this.getControls().get(0).getHSpan();
    }

    public int getVSpan() {
        if (this.getControls().size() == 0) {
            return 1;
        }
        return this.getControls().get(0).getVSpan();
    }

    public Flow getFlow() {
        return this.flow;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    public String toString() {
        return String.format("Row: %s / Cell: %s / Controls: %s", this.rowIndex, this.columnIndex, this.controls);
    }

    public int hashCode() {
        return this.rowIndex * 1000 + this.columnIndex;
    }
}

