/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.event;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.List;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuildResult;
import org.javabuilders.BuilderConfig;
import org.javabuilders.IPropertyList;
import org.javabuilders.Node;
import org.javabuilders.ValueListDefinition;
import org.javabuilders.Values;
import org.javabuilders.handler.AbstractPropertyHandler;
import org.javabuilders.util.BuilderUtils;

public class ComponentFocusListenerHandler
extends AbstractPropertyHandler
implements IPropertyList {
    private static final ComponentFocusListenerHandler singleton = new ComponentFocusListenerHandler(new String[0]);
    private static final List<ValueListDefinition> defs = ValueListDefinition.getCommonEventDefinitions((Class[])new Class[]{FocusEvent.class});

    public static final ComponentFocusListenerHandler getInstance() {
        return singleton;
    }

    private ComponentFocusListenerHandler(String ... consumedKeys) {
        super(new String[]{"onFocus", "onFocusLost"});
    }

    public void handle(BuilderConfig config, final BuildProcess process, final Node node, String key) throws BuildException {
        Component component = (Component)node.getMainObject();
        final Values onFocusList = (Values)node.getProperties().get("onFocus");
        final Values onFocusLostList = (Values)node.getProperties().get("onFocusLost");
        component.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (onFocusList != null) {
                    BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Node)node, (Collection)onFocusList.values(), (Object)e);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (onFocusLostList != null) {
                    BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Node)node, (Collection)onFocusLostList.values(), (Object)e);
                }
            }
        });
    }

    public Class<?> getApplicableClass() {
        return Component.class;
    }

    public boolean isList(String propertyName) {
        return true;
    }

    public List<ValueListDefinition> getValueListDefinitions(String propertyName) {
        return defs;
    }
}

