/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.property;

import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.Node;
import org.javabuilders.handler.AbstractPropertyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractButtonActionCommandHandler
extends AbstractPropertyHandler {
    public static final String ACTION_COMMAND = "actionCommand";
    private static final Logger logger = LoggerFactory.getLogger(AbstractButtonActionCommandHandler.class);
    private static final AbstractButtonActionCommandHandler singleton = new AbstractButtonActionCommandHandler();

    public static AbstractButtonActionCommandHandler getInstance() {
        return singleton;
    }

    private AbstractButtonActionCommandHandler() {
        super(new String[]{ACTION_COMMAND});
    }

    public void handle(BuilderConfig config, BuildProcess result, Node node, String key) throws BuildException {
        AbstractButton button = (AbstractButton)node.getMainObject();
        String actionCommand = String.valueOf(node.getProperties().get(key));
        button.setActionCommand(actionCommand);
        if (result.getCaller() != null && result.getCaller() instanceof ActionListener) {
            button.addActionListener((ActionListener)result.getCaller());
            if (logger.isDebugEnabled()) {
                logger.debug("Added calling ActionListener for actionCommand '{}' on button '{}'", (Object)actionCommand, (Object)button.getName());
            }
        }
    }

    public Class<?> getApplicableClass() {
        return AbstractButton.class;
    }
}

