/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler.validation.validator;

import org.javabuilders.BuildResult;
import org.javabuilders.NamedObjectProperty;
import org.javabuilders.handler.validation.ValidationMessage;
import org.javabuilders.handler.validation.ValidationMessageList;
import org.javabuilders.handler.validation.validator.AbstractValidator;

public class MinLengthValidator
extends AbstractValidator {
    private Integer minLength;

    public MinLengthValidator(NamedObjectProperty property, String label, String messageFormat, BuildResult result, Integer minLength) {
        super(property, label, messageFormat, result);
        this.minLength = minLength;
    }

    @Override
    public void validate(Object value, ValidationMessageList list) {
        String sValue = this.getStringValue(value);
        if (sValue == null || sValue.length() < this.minLength) {
            list.add(new ValidationMessage(this.getProperty(), this.getMessage(this.getLabel(), this.minLength)));
        }
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }
}

