/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.javabuilders.BuildProcess;
import org.javabuilders.util.JBStringUtils;

public class PrefixControlDefinition {
    public static final String SUFFIX_LABEL = "${CONTROL_SUFFIX_LABEL}";
    public static final String SUFFIX_PASCAL_CASE = "${CONTROL_SUFFIX_PASCAL_CASE}";
    private static Set<String> reservedPrefixes = new HashSet<String>();
    private Class<?> clazz;
    private Map<String, String> defaults = new HashMap<String, String>();

    public static void addReservedPrefix(String prefix) {
        reservedPrefixes.add(prefix);
    }

    public String getDefaultsAsYaml(BuildProcess process, String controlName, String suffix) {
        StringBuilder bld = new StringBuilder("{");
        if (this.defaults != null && this.defaults.size() > 0) {
            String suffixPascal = suffix.length() > 0 ? suffix.substring(0, 1).toLowerCase() + suffix.substring(1) : suffix;
            for (Map.Entry<String, String> entry : this.defaults.entrySet()) {
                String value;
                if (bld.length() > 1) {
                    bld.append(",");
                }
                if ((value = entry.getValue()).contains(SUFFIX_PASCAL_CASE)) {
                    if (reservedPrefixes.contains(value = value.replace(SUFFIX_PASCAL_CASE, suffixPascal)) && entry.getKey().matches("on[A-Z]+.*")) {
                        value = "do" + suffix;
                    }
                } else if (value.equals(SUFFIX_LABEL)) {
                    value = JBStringUtils.getDisplayLabel(process, this.clazz, suffixPascal);
                }
                bld.append(entry.getKey()).append(" : ").append(value);
            }
        }
        if (this.defaults == null || !this.defaults.containsKey("name")) {
            if (bld.length() > 1) {
                bld.append(",");
            }
            bld.append("name : ").append(controlName);
        }
        bld.append("}");
        return bld.toString();
    }

    public Class<?> getType() {
        return this.clazz;
    }

    public void setType(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Map<String, String> getDefaults() {
        return this.defaults;
    }

    public void setDefaults(Map<String, String> defaults) {
        this.defaults = defaults;
    }

    static {
        reservedPrefixes.add("new");
    }
}

