/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders;

import java.util.HashSet;
import java.util.Set;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.EventMethod;
import org.javabuilders.NamedObject;
import org.javabuilders.Node;
import org.javabuilders.Values;
import org.javabuilders.event.ObjectMethod;
import org.javabuilders.util.BuilderUtils;

public class ValueDefinition {
    private boolean isVariableLength = false;
    private Class<?> type = null;
    private Object defaultValue = null;
    private Set<Object> allowedValues = new HashSet<Object>();
    private String regexPattern = "";
    private String name;
    private Class<?>[] relatedTypes = new Class[0];

    public ValueDefinition(String name, Class<?> type) {
        BuilderUtils.validateNotNullAndNotEmpty("name", name);
        BuilderUtils.validateNotNullAndNotEmpty("type", type);
        this.name = name;
        this.type = type;
    }

    public ValueDefinition(String name, Class<?> type, Object defaultValue) {
        BuilderUtils.validateNotNullAndNotEmpty("name", name);
        BuilderUtils.validateNotNullAndNotEmpty("type", type);
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void validateValue(BuildProcess result, Node node, Object value, Values<Object, Object> valueList) throws BuildException {
        if (this.getType().equals(NamedObject.class)) {
            if (result.getBuildResult().containsKey(value)) {
                valueList.put(value, result.getBuildResult().get(value));
            } else {
                valueList.put(value, null, "'%s' is not a valid named object", value);
            }
        } else if (this.getType().equals(EventMethod.class)) {
            ObjectMethod method = BuilderUtils.getCallerEventMethod(result, (String)value, node.getMainObject().getClass(), this.getRelatedTypes());
            if (method != null) {
                valueList.put(value, method);
            } else {
                valueList.put(value, null, "No methods found on caller that correspond to the name '%s'", value);
            }
        } else {
            String stringValue;
            if (value != null && !this.getType().isAssignableFrom(value.getClass())) {
                valueList.put(value, null, "Incorrect type. Must be of %s", this.getType().getName());
            }
            if (!valueList.containsKey(value) && this.getAllowedValues().size() > 0) {
                boolean found = false;
                for (Object allowedValue : this.getAllowedValues()) {
                    if (value == null || !value.equals(allowedValue)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    valueList.put(value, null, "'%s' is not in list of allowed values: %s", value, this.getAllowedValues().toString());
                }
            }
            if (!valueList.containsKey(value) && this.getRegexPattern().length() > 0 && value instanceof String && !(stringValue = (String)value).matches(this.getRegexPattern())) {
                valueList.put(value, null, "Value '%s' failed regex validatoin '%s'", value, this.getRegexPattern());
            }
        }
        if (!valueList.containsKey(value)) {
            valueList.put(value, value);
        }
    }

    public Set<Object> getAllowedValues() {
        return this.allowedValues;
    }

    public boolean isVariableLength() {
        return this.isVariableLength;
    }

    public void setVariableLength(boolean isVariableLength) {
        this.isVariableLength = isVariableLength;
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }

    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
    }

    public String getName() {
        return this.name;
    }

    public Class<?>[] getRelatedTypes() {
        return this.relatedTypes;
    }

    public void setRelatedTypes(Class<?> ... relatedTypes) {
        this.relatedTypes = relatedTypes;
    }
}

