/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.layout;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.javabuilders.layout.HAlign;
import org.javabuilders.layout.LayoutException;
import org.javabuilders.layout.Size;
import org.javabuilders.layout.VAlign;

public class ControlConstraint {
    private static final Pattern pattern = Pattern.compile("^([\\<\\|\\>\\^\\-/]*)?(\".*\")?(\\$?[a-zA-Z0-9_]+)?(\\+\\*)?(\\+[0-9]+)?(\\+\\*)?(\\+[0-9]+)?(=[0-9])?(x*y*)?([\\<\\|\\>\\^\\-/]*)?$");
    public static final char HALIGN_RIGHT = '>';
    public static final char HALIGN_CENTER = '|';
    public static final char HALIGN_LEFT = '<';
    public static final char VALIGN_MIDDLE = '-';
    public static final char VALIGN_BOTTOM = '/';
    public static final char VALIGN_TOP = '^';
    public static final char SIZE_GROUP_INDICATOR = '=';
    public static final String SIZE_GROUP_X_INDICATOR = "x";
    public static final String SIZE_GROUP_Y_INDICATOR = "y";
    public static final char WIDTH_MAX = '>';
    public static final char WIDTH_PREF = '|';
    public static final char WIDTH_MIN = '<';
    public static final char QUOTE = '\"';
    private static final List<String> postIdentifiers = new ArrayList<String>();
    private String controlName = "";
    private String constraintText = "";
    private int hSpan = 1;
    private int vSpan = 1;
    private HAlign hAlign = HAlign.DEFAULT;
    private VAlign vAlign = VAlign.DEFAULT;
    private Integer sizeGroup = null;
    private boolean sizeGroupX = false;
    private boolean sizeGroupY = false;
    private boolean isMaxHSpan = false;
    private boolean isMaxVSpan = false;
    private Size hSize = Size.DEFAULT;
    private Size vSize = Size.DEFAULT;

    public ControlConstraint(String constraintText) throws LayoutException {
        this.constraintText = constraintText;
        Matcher m = pattern.matcher(constraintText);
        if (m.find()) {
            char[] chars;
            if (m.group(1) != null) {
                block16: for (char c : chars = m.group(1).toCharArray()) {
                    switch (c) {
                        case '<': {
                            this.hAlign = HAlign.LEFT;
                            continue block16;
                        }
                        case '|': {
                            this.hAlign = HAlign.CENTER;
                            continue block16;
                        }
                        case '>': {
                            this.hAlign = HAlign.RIGHT;
                            continue block16;
                        }
                        case '^': {
                            this.vAlign = VAlign.TOP;
                            continue block16;
                        }
                        case '-': {
                            this.vAlign = VAlign.MIDDLE;
                            continue block16;
                        }
                        case '/': {
                            this.vAlign = VAlign.BOTTOM;
                        }
                    }
                }
            }
            if (m.group(2) != null) {
                this.controlName = m.group(2);
            }
            if (m.group(3) != null) {
                this.controlName = m.group(3);
            }
            if (m.group(4) != null) {
                this.setMaxHSpan(true);
            }
            if (m.group(5) != null) {
                this.setHSpan(Integer.parseInt(m.group(5).substring(1)));
            }
            if (m.group(6) != null) {
                this.setMaxVSpan(true);
            }
            if (m.group(7) != null) {
                this.setVSpan(Integer.parseInt(m.group(7).substring(1)));
            }
            if (m.group(8) != null) {
                this.setSizeGroup(Integer.parseInt(m.group(8).substring(1)));
            }
            if (SIZE_GROUP_X_INDICATOR.equals(m.group(9))) {
                this.sizeGroupX = true;
            } else if (SIZE_GROUP_Y_INDICATOR.equals(m.group(9))) {
                this.sizeGroupY = true;
            }
            if (m.group(10) != null) {
                block17: for (char c : chars = m.group(10).toCharArray()) {
                    switch (c) {
                        case '<': {
                            this.hSize = Size.MIN;
                            continue block17;
                        }
                        case '|': {
                            this.hSize = Size.PREF;
                            continue block17;
                        }
                        case '>': {
                            this.hSize = Size.MAX;
                            continue block17;
                        }
                        case '^': {
                            this.vSize = Size.MIN;
                            continue block17;
                        }
                        case '-': {
                            this.vSize = Size.PREF;
                            continue block17;
                        }
                        case '/': {
                            this.vSize = Size.MAX;
                        }
                    }
                }
            }
        } else {
            throw new LayoutException("Unable to parse {0} control constraint", constraintText);
        }
    }

    public String getControlName() {
        return this.controlName;
    }

    public void setControlName(String controlName) {
        this.controlName = controlName;
    }

    public int getHSpan() {
        return this.hSpan;
    }

    public void setHSpan(int spanHorizontal) {
        this.hSpan = spanHorizontal;
    }

    public int getVSpan() {
        return this.vSpan;
    }

    public void setVSpan(int spanVertical) {
        this.vSpan = spanVertical;
    }

    public HAlign getHAlign() {
        return this.hAlign;
    }

    public void setHAlign(HAlign align) {
        this.hAlign = align;
    }

    public VAlign getVAlign() {
        return this.vAlign;
    }

    public void setVAlign(VAlign align) {
        this.vAlign = align;
    }

    public String toString() {
        return String.format("Name: %s, hAlign: %s, vAlign: %s, hSpan: %s, vSpan: %s", new Object[]{this.controlName, this.hAlign, this.vAlign, this.hSpan, this.vSpan});
    }

    public int hashCode() {
        return this.controlName.hashCode();
    }

    public Integer getSizeGroup() {
        return this.sizeGroup;
    }

    public void setSizeGroup(Integer sizeGroup) {
        this.sizeGroup = sizeGroup;
    }

    public boolean isMaxHSpan() {
        return this.isMaxHSpan;
    }

    public void setMaxHSpan(boolean isMaxHSpan) {
        this.isMaxHSpan = isMaxHSpan;
    }

    public boolean isMaxVSpan() {
        return this.isMaxVSpan;
    }

    public void setMaxVSpan(boolean isMaxVSpan) {
        this.isMaxVSpan = isMaxVSpan;
    }

    public boolean isSizeGroupX() {
        return this.sizeGroupX;
    }

    public boolean isSizeGroupY() {
        return this.sizeGroupY;
    }

    public Size getHSize() {
        return this.hSize;
    }

    public void setHSize(Size hSize) {
        this.hSize = hSize;
    }

    public Size getVSize() {
        return this.vSize;
    }

    public void setVSize(Size vSize) {
        this.vSize = vSize;
    }

    static {
        postIdentifiers.add(String.valueOf('='));
        postIdentifiers.add(String.valueOf('+'));
    }
}

