package net.oni2.svnaccess;

/**
 * Interface for listeners to status updates during checkout/update from SVN
 * 
 * @author Christian Illy
 */
public interface SVNUpdateListener {

	/**
	 * Called after checking out / updating a single file
	 * 
	 * @param done
	 *            Files done
	 * @param total
	 *            Total files for the current checkout/update
	 */
	public void statusUpdate(int done, int total);
}
