package net.oni2.svnaccess;

import java.util.Vector;

import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;


/**
 * Used to get the files in a SVN repository
 * 
 * @author Christian Illy
 */
public class DirEntryHandler implements ISVNDirEntryHandler {

	Vector<String>	target;


	/**
	 * Create a new DirEntryHandler with a list to store the found files in.
	 * 
	 * @param targetList
	 *            Vector used to store the file names
	 */
	public DirEntryHandler(Vector<String> targetList) {
		this.target = targetList;
	}

	@Override
	public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
		if (dirEntry.getKind() == SVNNodeKind.FILE)
			target.add(dirEntry.getURL().getPath());
	}

}
