package net.oni2.svnaccess;

import java.util.Vector;

import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;


/**
 * Handler to return checkout/update status
 * 
 * @author Christian Illy
 */
public class UpdateEventHandler implements ISVNEventHandler {

	Vector<String>		list;
	int					objects;
	SVNUpdateListener	listener;


	/**
	 * Create a new UpdateEventHandler with a file name list
	 * 
	 * @param infoList
	 *            List containing the file names of all files which will be
	 *            checked out / updated
	 * @param listener
	 *            Listener to send status events to
	 */
	public UpdateEventHandler(Vector<String> infoList,
			SVNUpdateListener listener) {
		this.list = infoList;
		this.listener = listener;
		if (list != null)
			objects = list.size();
		else
			objects = -1;
	}

	public void handleEvent(SVNEvent event, double progress) {
		SVNEventAction action = event.getAction();
		if ((action == SVNEventAction.UPDATE_ADD)
				|| (action == SVNEventAction.UPDATE_UPDATE)) {
			if (list != null) {
				list.remove(event.getURL().getPath());
				if (listener != null) {
					listener.statusUpdate(objects - list.size(), objects);
				} else {
					System.out.println((objects - list.size()) + " of "
							+ objects + " done");
				}
			}
		}
	}

	/*
	 * Should be implemented to check if the current operation is cancelled. If
	 * it is, this method should throw an SVNCancelException.
	 */
	public void checkCancelled() throws SVNCancelException {
	}
}