package net.oni2.aeinstaller.updater.backend;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

/**
 * @author Christian Illy
 */
public class Paths {

	/**
	 * Get the Jar path
	 * 
	 * @return Path
	 */
	public static File getInstallerPath() {
		String jarPath = Paths.class.getProtectionDomain().getCodeSource()
				.getLocation().getPath();
		String decodedPath = null;
		try {
			decodedPath = URLDecoder.decode(jarPath, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		return new File(decodedPath).getParentFile();
	}

	/**
	 * Get the preferences path
	 * 
	 * @return Path
	 */
	public static File getPrefsPath() {
		return getInstallerPath();
	}

	/**
	 * Get the path to store downloaded files
	 * 
	 * @return Download path
	 */
	public static File getDownloadPath() {
		return new File(getTempPath(), "downloads");
	}

	/**
	 * Get the systems temp-path
	 * 
	 * @return Path
	 */
	public static File getTempPath() {
		return new File(System.getProperty("java.io.tmpdir"), "oni_aei");
	}

}
