#ifndef ONI_GAMESTATE_H
#define ONI_GAMESTATE_H

#include "Oni_Character.h"

typedef struct {
	float X;
	float Y;
	float Z;	
} Vector3; //probably move to utilities...

typedef struct {
	float X;
	float Y;
	float Z;
	float W;
} Quaternion;

typedef struct {
	float RotationScale[9];
	Vector3 Translation;
} Matrix4x3;

typedef struct {
	Vector3 Center;
	float Radius;
} Sphere;

typedef struct 
{
  int StartTime;
  int field_4;
  char Active;
  char field_9;
} Letterbox;

typedef struct 
{
  __int16 Count;
  __int16 field_2;
  int Memory;
} DoorArray;

typedef struct 
{
  int Count;
  int Head;
}PHNodeList;

typedef struct
{
  PHNodeList OutList;
  PHNodeList InList;
  int AKVA;
  int field_14;
  int XTiles;
  int ZTiles;
  int GridSize;
  char field_24;
  char NoGrid;
  char gap_26[2];
  int GridData;
  int field_2D;
  __int16 field_31;
  char gap_32[2];
  int DynamicGrid;
  int field_39;
  int field_3D;
  int field_41;
  int field_45;
  int field_49;
  int field_4D;
  int field_51;
  int field_55;
  int field_59;
  int field_5D;
  int field_61;
  int field_65;
  int field_69;
  int field_6D;
  int field_71;
  int field_75;
  __int16 Visited;
  __int16 field_7A;
  int TraverseQueueNext;
  int field_81;
  int field_85;
  int field_89;
  int field_8D;
  int field_91;
  int field_95;
  int field_99;
} PHGraphNode;
typedef struct 
{
  int field_0;
  int field_4;
  int field_8;
  int field_C;
  int field_10;
  int field_14;
  int field_18;
  int field_1C;
  int field_20;
  int field_24;
  int field_28;
  int field_2C;
  int field_30;
  int field_34;
  int field_38;
  int field_3C;
  int field_40;
} MotionBlur;

typedef struct 
{
  char field_0[2052];
} Shadow;

typedef struct
{
  int ONSK;
  Vector3 PlanetPositions[8];
  int StarSpriteArray;
  int Skybox;
  int field_6C;
  int field_70;
  int field_74;
  int field_78;
  int field_7C;
  int field_80;
  int field_84;
  int field_88;
  int field_8C;
  int field_90;
  int field_94;
  int field_98;
  int field_9C;
  int field_A0;
  int field_A4;
  int field_A8;
  int field_AC;
  int field_B0;
  int field_B4;
  int field_B8;
  int field_BC;
  int field_C0;
  int field_C4;
  int field_C8;
  int field_CC;
  int field_D0;
  int field_D4;
  int field_D8;
  int field_DC;
  float field_E0;
  int field_E4;
  int field_E8;
  int field_EC;
  int field_F0;
  int field_F4;
  int field_F8;
  int field_FC;
  int field_100;
  int field_104;
  int field_108;
  int field_10C;
  int field_110;
  int field_114;
  int field_118;
  int field_11C;
  int field_120;
  int field_124;
  int field_128;
  int field_12C;
  int field_130;
  int field_134;
  int field_138;
  int field_13C;
  int field_140;
  int field_144;
  int field_148;
  int field_14C;
  int field_150;
  int field_154;
  int field_158;
  int field_15C;
  int field_160;
  float field_164;
  int field_168;
  int field_16C;
  int field_170;
  int field_174;
  int field_178;
  int field_17C;
  int field_180;
  int field_184;
  int field_188;
  int field_18C;
  int field_190;
  int field_194;
  int field_198;
  int field_19C;
  int field_1A0;
  int field_1A4;
  int field_1A8;
  int field_1AC;
  int field_1B0;
  int field_1B4;
  int field_1B8;
  int field_1BC;
  int field_1C0;
  int field_1C4;
  int field_1C8;
  int field_1CC;
  int field_1D0;
  int field_1D4;
  int field_1D8;
  int field_1DC;
  int field_1E0;
  int field_1E4;
  int field_1E8;
  int field_1EC;
  int field_1F0;
  int field_1F4;
  int field_1F8;
  int field_1FC;
  int field_200;
  float field_204;
  int field_208;
  int field_20C;
  int field_210;
  int field_214;
  int field_218;
  int field_21C;
  int field_220;
  int field_224;
  int field_228;
  int field_22C;
  int field_230;
  int field_234;
  int field_238;
  int field_23C;
  int field_240;
  int field_244;
  int field_248;
  Vector3 SunFlarePosition;
  Vector3 field_258;
  int field_264;
  int field_268;
  int field_26C;
  int field_270;
  Vector3 field_274;
  int field_280;
  int field_284;
  int field_288;
  int field_28C;
} Sky;



typedef struct {
	Sphere Sphere_; //fix this name
	int Child1;
	int Child2;	
} SphereTreeNode;

typedef struct {
	Vector3 Min;
	Vector3 Max;
} BoundingBox;


/*  202 */ typedef struct 
{
  char Name[32];
  __int16 Id;
  __int16 field_22;
  int Length;
} PatrolPathOSD;

/*  396 */ typedef struct 
{
  int Type;
  int field_4;
  int field_8;
  int field_C;
  int field_10;
} PatrolPathPoint;

enum { //action flags
	Action_Escape                    = 1,
	Action_Console                   = 2,
	Action_PauseScreen               = 4,
	Action_Cutscene_1                = 8,
	Action_Cutscene_2                = 0x10,
	Action_F4                        = 0x20,
	Action_F5                        = 0x40,
	Action_F6                        = 0x80,
	Action_F7                        = 0x100,
	Action_F8                        = 0x200,
	Action_StartRecord               = 0x400,
	Action_StopRecord                = 0x800,
	Action_PlayRecord                = 0x1000,
	Action_F12                       = 0x2000,
	Action_Unknown1                  = 0x4000,
	Action_LookMode                  = 0x8000,
	Action_Screenshot                = 0x10000,
	Action_Unknown2                  = 0x20000,
	Action_Unknown3                  = 0x40000,
	Action_Unknown4                  = 0x80000,
	Action_Unknown5                  = 0x100000,
	Action_Forward                   = 0x200000,
	Action_Backward                  = 0x400000,
	Action_TurnLeft                  = 0x800000,
	Action_TurnRight                 = 0x1000000,
	Action_StepLeft                  = 0x2000000,
	Action_StepRight                 = 0x4000000,
	Action_Jump                      = 0x8000000,
	Action_Crouch                    = 0x10000000,
	Action_Punch                     = 0x20000000,
	Action_Kick                      = 0x40000000,
	Action_Block                     = 0x80000000,
	//used in second action field
	Action2_Walk                     = 1,
	Action2_Action                   = 2,
	Action2_Hypo                     = 4,
	Action2_Reload                   = 8,
	Action2_Swap                     = 0x10,
	Action2_Drop                     = 0x20,
	Action2_Fire1                    = 0x40,
	Action2_Fire2                    = 0x80,
	Action2_Fire3                    = 0x100,
};


typedef struct {
	int32_t Actions1;
	int32_t Actions2;
} InputAction;


typedef struct {
	float MouseDeltaX;
	float MouseDeltaY;
	float field_8;
	float field_C;
	InputAction Current;
	InputAction Stopped;
	InputAction Start;
	InputAction Stop;
} GameInput;

typedef struct {
	int Type;				//'CHAR' etc.
	int ObjectId;			//not needed
	int Flags;				//The flags of the object...not used for CHAR
	Vector3 Position;		//Position of Object
	Vector3 Rotation;		//Rotation of Object
	int EditorCallbacks;	//Lets try not to mess with it for now. :P
	int field_28;			//unknown
} OSD_Header;

typedef struct 
{
	short ID;	
	short flags;

	short keys;
	short open_time;

	float activate_radius_squared;

	short state;	
	short blocked_frames;						

	short open_time_left;						
	short some_timer;

	Vector3 center_offset;						
	char name[63];
	char pad;
	void *class;
} DoorOSD;

typedef struct {
	OSD_Header OSD;
	DoorOSD Door; //incomplete
} DoorObject;

typedef struct {
	int32_t Flags;
	int32_t Frame;
	int32_t field_8;
	int32_t field_C;
	int32_t field_10;
	int32_t field_14;
	int32_t field_18;
	int32_t field_1C;
	int32_t FILMInstance;
} PlayingFilm;

typedef enum {
	chr_isplayer          = 1 << 0,
	chr_randomskin        = 1 << 1,
	chr_notprespawned     = 1 << 2,
	chr_noncombatant      = 1 << 3,
	chr_multispawnable    = 1 << 4,
	chr_unkillable        = 1 << 5,
	chr_superammo         = 1 << 6,
	chr_omniscient        = 1 << 8,
	chr_haslsi            = 1 << 9,
	chr_boss              = 1 << 10,
	chr_upgradedifficulty = 1 << 11,
	chr_noautodrop        = 1 << 12,
	chr_dontaim           = 1 << 13,
	chr_nocollision       = 1 << 17,
	chr_noshadow          = 1 << 24,
	chr_invincible        = 1 << 25,
	chr_bossshield        = 1 << 30,
	chr_weaponimmune      = 1 << 31,
} chr_flags;


typedef struct {
	uint32_t Options;				//A bitset. Someone had better define these
	char Class[64];					//Name of the ONCC we use. ONCCName in idb
	char Name[32];					//Name of the character. ie: ai2_spawn Muro
	char Weapon[64];				//Name of the weapon he holds. ONWCName in idb
	char ScriptSpawn[32];			//Script function called when char spawns
	char ScriptDie[32];				//Script function called when char dies
	char ScriptAware[32];			//Script function called when char detects something
	char ScriptAlarm[32];			//Script function called when char is alarmed at something
	char ScriptHurt[32];			//Script function called when char is hurt for the first time
	char ScriptDefeat[32];			//Script function called when char is at 1 HP
	char ScriptNoPath[32];			//Script function called when char loses path. Broken.
	char ScriptNoAmmo[32];			//Script function called when char is out of ammo for the first time. Char must have ammo at spawn.
	int32_t AdditionalHealth;		//Additional Health given to the character
	int16_t AmmoUsed;				//Ammo given for the char to use
	int16_t AmmoDropped;			//Ammo the char drops
	int16_t CellsUsed;				//Cells given for the char to use
	int16_t CellsDropped;			//Cells the char drops
	int16_t HypoUsed;				//Hypo given for the char to use
	int16_t HypoDropped;			//Hypo the char drops
	int16_t ShieldUsed;				//Bullet shield given for the char to use
	int16_t ShieldDropped;			//Bullet shield the char drops
	int16_t CloakUsed;				//Phase Cloak given for the char to use
	int16_t CloakDropped;			//Phase Cloak the char drops
	int16_t NCIUsed;				//Don't use this...
	int16_t NCIDropped;				//Don't use this...
	int32_t TeamID;					//Team ID
	int32_t AmmoPercent;			//Percent of weapon ammo full
	int32_t JobID;					//Job ID...
									//0 - none 
									//1 - idle 
									//2 - guard (never used in Oni) 
									//3 - patrol 
									//4 - teambattle (never used in Oni)
	int16_t PatrolID;				//patrol path ID (reference to the Patrol_Path.BINA file)
	int16_t CombatID;				//combat ID (reference to the Combat.BINA file)
	int16_t	MeleeID;				//melee ID (reference to the Melee Profile.BINA file)
	int16_t NeutralID;				//neutral ID (reference to the Neutral.BINA file)
	int32_t	AlarmGroups;			//Bitset. http://wiki.oni2.net/CHAR
	int32_t InitialAlertLevel;		//0 - lull, 1 - low, 2 - medium, 3 - high, 4 - combat
	int32_t MinimalAlertLevel;		//0 - lull, 1 - low, 2 - medium, 3 - high, 4 - combat
	int32_t StartJobAlertLevel;		//0 - lull, 1 - low, 2 - medium, 3 - high, 4 - combat
	int32_t InvestigatingAlertLevel;//0 - lull, 1 - low, 2 - medium, 3 - high, 4 - combat
	int32_t PursuitStrongLow;
	int32_t PursuitWeakLow;
	int32_t PursuitStrongHigh;
	int32_t PursuitWeakHigh;
	int32_t Pursuit5;
	int32_t field_1FC;
} CharacterOSD;

typedef struct {
	OSD_Header Header;
	CharacterOSD OSD;
} CharacterObject;

typedef struct {
	Vector3 Center;
	float Radius;
} BoundingSphere;

typedef struct {
	int32_t ONCP; //probably pointer
	int32_t field_4;	//who knows?
	int32_t Instance; //probably link to actual particle
	int32_t Bone; //duh
} AttachedParticle;


typedef struct 
{
  __int16 Index;
  __int16 Flags;
  int Class;
  int Character;
  Matrix4x3 Matrix;
  int PhyContext;
  int Facing;
  __int16 FadeTimer;
  __int16 TimeToFade;
  int CreationTime;
  __int16 ShotDelay1;
  __int16 ShotDelay2;
  __int16 PauseBeforeReload;
  __int16 PauseAfterReload;
  __int16 ActiveFireModeLength;
  __int16 AmmoCount;
  __int16 field_58;
  __int16 FiringDelays[16];
  char gap_7a[2];
  int ParticleInstances[16];
  int field_BC[16];
  int field_FC;
  int DodgeFiringSpreadPtr;
  int field_104;
  int field_108;
  int field_10C;
  char gap_110[20];
  Vector3 Center;
  int NodeList[16];
} Weapon;

typedef struct { //Inventory
	Weapon* Weapons[3];
	int8_t z_forced_holster;
	int8_t z_forced_holster_is_magic;
	int16_t AmmoUsed;				//Ammo given for the char to use
	int16_t HypoUsed;				//Hypo given for the char to use
	int16_t CellsUsed;				//Cells given for the char to use
	int16_t AmmoDropped;			//Ammo the char drops
	int16_t HypoDropped;			//Hypo the char drops
	int16_t CellsDropped;			//Cells the char drops
	int16_t hypoRemaining;	//who knows? InverseHypoRegenRate?
	int16_t hypoTimer;	
	int16_t pad;
	char hasLSI;
	char field_1B5;
	int16_t	shieldDisplayAmount;
	int16_t ShieldUsed;				//Bullet shield given for the char to use
	int16_t CloakUsed;				//Phase Cloak given for the char to use
	int32_t numInvisibleFrames;			//probably bullet shield dropped
	int32_t DoorKeys;		//Lol. We can use this later for other sorts of items.
} Inventory;

typedef struct {
	uint32_t SphereTree;
	Vector3 ObBox[8];
	Vector3 * ObBowPtr;
	Vector3 Velocity;
	Quaternion field_74;
	Vector3 Position;
	Quaternion Rotation;
	float Scale;
	Matrix4x3 Matrix;
	Matrix4x3 InitMatrix;
	float field_104;
	float Gravity;
	float field_10C;
	float field_110;
	float Friction_1;
	float Friction_2;
	Vector3 Force;
	uint32_t Flags;
	uint32_t Type;
	char AnimState[0x18];
	void* Callbacks;
	void* Owner;
} PhyContext;
typedef struct
{
  int field_0;
  int NumContacts;
  int FirstContact;
  int NotifyKnowledgeCallback;
} AI2KnowledgeState;

typedef struct 
{
  char Name[128];
  __int16 ImpactId;
} ONCCImpact;

typedef struct 
{
  int RecoilCompensation;
  int BestAimingAngle;
  int ShotGroupError;
  int ShotGroupDecay;
  int ShotingInaccuracyMultiplier;
  __int16 MinDelayBetweenShots;
  __int16 MaxDelayBetweenShots;
} ONCCWeaponSkill;

typedef struct 
{
  __int16 field_0;
  __int16 field_2;
  __int16 field_4;
  __int16 field_6;
  __int16 field_8;
  __int16 field_A;
  __int16 field_C;
  __int16 field_E;
  __int16 field_10;
  __int16 field_12;
  __int16 field_14;
  char Loaded;
  char field_17;
  int field_18;
  char HurtLightSoundName[32];
  char HurtMediumSoundName[32];
  char HurtHeavySoundName[32];
  char DeathSoundName[32];
  int HurtLightSoundPtr;
  int HurtMediumSoundPtr;
  int HurtHeavySoundPtr;
  int DeathSoundPtr;
}HurtParams;


typedef struct
{
  int field_0;
  int Gravity;
  float JumpStartVelocity;
  float MaxFallingVelocity;
  float JumpAcceleration;
  __int16 field_14;
  __int16 JetpackTimer;
  float MaxFallingHeightWithoutDamage;
  float MaxFallingHeightWithDamage;
  int ShadowTexture;
  float ShadowMaxHeight;
  float ShadowFadeHeight;
  float ShadowSize1;
  float ShadowSize2;
  float ShadowSize3;
  __int16 field_38;
  __int16 field_3A;
  int field_3C;
  char field_40;
  char field_41;
  __int16 field_42;
  int field_44;
  int field_48;
  int field_4C;
  int field_50;
  int field_54;
  int field_58;
  __int16 InverseHypoRegenerationRate;
  __int16 field_5E;
  int field_60;
  int field_64;
  int field_68;
  int field_6C;
  int field_70;
  HurtParams HurtParams;
  int AIOptions;
  int AIRotationSpeed;
  __int16 MinimalDazeTime;
  __int16 MaximalDazeTime;
  __int16 MinimalRealiseFiringSpreadTime;
  __int16 MaximalRealiseFiringSpreadTime;
  int MinimalFiringSpreadDodge;
  int MaximalFiringSpreadDodge;
  int field_138;
  int field_13C;
  int field_140;
  int field_144;
  int field_148;
  int field_14C;
  int field_150;
  ONCCWeaponSkill WeaponSkills[13];
  int field_28C;
  int field_290;
  int field_294;
  int TauntChance;
  int GoForGunChance;
  int RunPickupChance;
  __int16 CombatId;
  __int16 MeleeId;
  char SoundProbabilities[10];
  char gap_2b2[2];
  char TauntSound[32];
  char AlertSound[32];
  char StartleSound[32];
  char CheckBodySound[32];
  char PursueSound[32];
  char CoverSound[32];
  char SuperpunchSound[32];
  char SuperKickSound[32];
  char Super3Sound[32];
  char Super4Sound[32];
  int CentralVisionRange;
  int PeripheralVisionRange;
  int HFov;
  int CentralVisionCurve;
  int CentralVFOV;
  int PeripheralVisionCurve;
  int PeripheralVFOV;
  int HostileThreatDefiniteTimer;
  int HostileThreatStrongTimer;
  int HostileThreatWeakTimer;
  int FriendlyThreadDefiniteTimer;
  int FriendlyThreatStrongTimer;
  int FriendlyThreatWeakTimer;
  int EarshotRadius;
  int ONCV;
  int ONCP;
  int ONIA;
  char ImpactsLoaded;
  char gap_439[1];
  __int16 ImpactModifier;
  char ImpactModifierName[16];
  ONCCImpact Impacts[15];
  char gap_bea[2];
  char DeathParticleName[64];
  int DeathParticlePtr;
  int BodySurfaceCache;
  int TRBS;
  int TRMA;
  int CBPM;
  int CBPI;
  int PeaceTimer;
  int IdleTimer1;
  int IdleTimer2;
  int BaseHealth;
  int field_C54;
  int MinBodySizeFactor;
  int MaxBodySizeFactor;
  int field_C60[7];
  int field_C7C;
  int TRAC;
  int TRSC;
  char gap_c88[2];
  __int16 DeathDeleteTimer;
  char WeaponHand;
  char HasDaodanPowers;
  char HasSuperShield;
  char CantTouchThis;
} ONCC;


/*  398 */ typedef struct 
{
  char Number;
  char gap_1[1];
  __int16 ActiveCharacterIndex;
  int Flags;
  int field_8;
  ONCC* ONCC;
  __int16 ONCCnumber;
  __int16 Team;
  char Name[32];
  int BodySize;
  int Health;
  int MaxHealth;
  __int16 AISA_ID;
  char gap_42[2];
  int field_44;
  char ScriptNew[32];
  char ScriptDie[32];
  char ScriptSeen[32];
  char ScriptAlarm[32];
  char ScriptHurt[32];
  char ScriptDefeat[32];
  char ScriptLowAmmo[32];
  //char ScriptNoPath[32];
  char ScriptNoPath[28];
  int RegenHax;
  Vector3 Position;
  Vector3 LastPosition;
  Vector3 Location;
  float Facing;
  float DesiredFacing;
  float CosmeticFacing;
  int field_178;
  int field_17C;
  int field_180;
  int BNV;
  int GraphNode;
  float PelvisHeight;
  int field_190;
  Inventory Inventory;
  Vector3 Velocity;
  int field_1D0;
  int field_1D4;
  int field_1D8;
  int field_1DC;
  int field_1E0;
  int IdleDelay;
  int charType;
  char gap_1ec[4];
  int CombatFlags;
  int JobId;
  int Goal;
  int field_1FC;
  __int16 field_200;
  char gap_202[6];
  int field_208;
  char gap_20c[588];
  char field_458;
  char gap_459[352];
  char field_5B9;
  char gap_5ba[14];
  char field_5C8;
  char gap_5c9[359];
  int field_730;
  int field_734;
  int field_738;
  char gap_73c[380];
  char CombatState;
  char gap_8b9[7];
  PatrolPathOSD PatrolPathOSD_;
  PatrolPathPoint PatrolPathPoints[64];
  char gap_de8[392];
  int Combat_StatePtr;
  AI2KnowledgeState KnowledgeState_;
  char gap_f84[4];
  int AlertDecayTimer;
  int field_F8C;
  int field_F90;
  int AlertLevel;
  int MinimalAlertLevel;
  int StartJobAlertLevel;
  int InvestigatingAlertLevel;
  int StartleTime;
  int field_FA8;
  int field_FAC;
  int field_FB0;
  int Pursue1;
  int Pursue2;
  int Pursue3;
  int Pursue4;
  int Pursue5;
  char field_FC8;
  char gap_fc9[3];
  int field_FCC;
  char gap_fd0[8];
  int AlarmGroups;
  int field_FDC;
  int field_FE0;
  int field_FE4;
  int field_FE8;
  int field_FEC;
  int field_FF0;
  int field_FF4;
  int field_FF8;
  int field_FFC;
  int field_1000;
  int field_1004;
  int field_1008;
  __int16 field_100C;
  __int16 field_100E;
  int field_1010;
  int field_1014;
  int field_1018;
  char field_101C;
  char gap_101d[3];
  int DazeTimer;
  __int16 field_1024;
  __int16 field_1026;
  __int16 field_1028;
  __int16 field_102A;
  int field_102C;
  int field_1030;
  int field_1034;
  char gap_1038[20];
  int field_104C;
  int field_1050;
  int field_1054;
  int field_1058;
  int field_105C;
  int field_1060;
  int field_1064;
  int MeleePtr;
  int field_106C;
  __int16 field_1070;
  char gap_1072[126];
  int Path_DestinationType;
  int Path_TypeSpecificInfo;
  char Path_MovementState;
  char gap_10f9[3];
  int Path_OrientTo;
  Vector3 Path_DestinationPoint;
  int field_110C;
  int field_1110;
  Vector3 field_1114;
  Vector3 field_1120;
  char Path_State;
  char field_112D;
  char field_112E;
  char gap_112f[1];
  Vector3 field_1130;
  int field_113C;
  int field_1140;
  int field_1144;
  char field_1148;
  char gap_1149[3];
  int Path_CurrentNodeNumber;
  int Path_NumNodes;
  Vector3 Path_From;
  Vector3 Path_To;
  int Path_GraphFromNodePtr;
  int Path_GraphToNodePtr;
  int field_1174;
  char gap_1178[12];
  int field_1184;
  char gap_1188[776];
  int Path_LastError;
  int Path_RepathDelay;
  int Path_Repaths;
  int Path_RepathDecayTimer;
  int field_14A0;
  int MovementMode;
  char field_14A8;
  char gap_14a9[3];
  int field_14AC;
  int MovementModifiers;
  int field_14B4;
  char gap_14b8[188];
  int field_1574;
  int FacingState;
  int FacingAt_Destination;
  char field_1580;
  char field_1581;
  char gap_1582[2];
  int Aiming_At_Type;
  Vector3 Aiming_At;
  int field_1594;
  int field_1598;
  int field_159C;
  int GlancingState;
  Vector3 GlancingDirOrPos;
  char field_15B0;
  char gap_15b1[3];
  int field_15B4;
  int field_15B8;
  int field_15BC;
  int field_15C0;
  int field_15C4;
  int field_15C8;
  int field_15CC;
  int field_15D0;
  int field_15D4;
  int field_15D8;
  int field_15DC;
  int field_15E0;
  int field_15E4;
  int field_15E8;
  int AIBlockFunction;
  char field_15F0;
  char field_15F1;
  char field_15F2;
  char gap_15f3[1];
  int field_15F4;
  int field_15F8;
  int field_15FC;
  int field_1600;
  char gap_1604[4];
  int field_1608;
  int field_160C;
  char gap_1610[4];
  int field_1614;
  char gap_1618[20];
  int field_162C;
  int field_1630;
  int field_1634;
  int field_1638;
  int field_163C;
  int field_1640;
  __int16 field_1644;
  char gap_1646[2];
  BoundingBox BoundingBox_;
  char gap_1660[4];
  int BossShieldPower;
  int field_1668;
  char gap_166c[4];
  uint32_t Kills;
  uint32_t Damage;
  int field_1678;
  int field_167C;
  int CurrentConsoleActionMarker;
  int field_1684;
  __int16 field_1688;
  __int16 field_168A;
  int field_168C;
  int field_1690;
  char field_1694;
  char field_1695;
  __int16 field_1696;
  int field_1698;
  int field_169C;
} Character;

typedef struct 
{
  int Nodes;
  int NodeCount;
  int field_8;
  int TraverseQueueHead;
  int field_10;
  int CacheLrar;
  int CacheMem;
  int field_1C;
  int field_20;
  int field_24;
}PHGraph
;

/*  388 */ typedef struct //activecharacter
{
  __int16 Number;
  __int16 field_2;
  PhyContext* PhyContext;
  SphereTreeNode SphereTree;
  SphereTreeNode SphereTree3[4];
  SphereTreeNode SphereTree2[2];
  __int16 field_B0;
  __int16 field_B2;
  __int16 field_B4;
  char field_B6;
  char gap_b7[1];
  Vector3 field_B8;
  Vector3 AccelerateWith;
  int field_D0;
  Vector3 field_D4;
  __int16 field_E0;
  char gap_e2[2];
  int field_E4;
  int field_E8;
  int field_EC;
  int field_F0;
  __int16 field_F4;
  __int16 IsInAir;
  Vector3 FallingVelocity;
  Vector3 JumpVelocity;
  char field_110;
  char field_111;
  __int16 field_112;
  __int16 field_114;
  char gap_116[2];
  int field_118;
  int field_11C;
  int field_120;
  int field_124;
  int field_128;
  int field_12C;
  BoundingSphere BoundingSphere;
  Vector3 field_140;
  Vector3 field_14C;
  int field_158;
  int field_15C;
  Vector3 Location;
  char gap_16c[24];
  int AkiraNode;
  int GraphNode;
  int PelvisHeight;
  int Movement_StatePtr;
  int ActiveWeapon;
  int field_198;
  int InventoryWeapon;
  char gap_1a0[2];
  __int16 RedAmmoClipCount;
  __int16 HypoCount;
  __int16 GreenAmmoClipCount;
  __int16 RedAmmoClipDropCount;
  __int16 HypoDropCount;
  __int16 GreenAmmoClipDropCount;
  __int16 field_1AE;
  __int16 InverseHypoRegenerationRate;
  char DropShield;
  char DropPhaseCloack;
  char field_1B4;
  char gap_1b5[1];
  __int16 field_1B6;
  __int16 Shield;
  __int16 PhaseCloacking;
  int field_1BC;
  char gap_1c0[4];
  __int16 field_1C4;
  char gap_1c6[10];
  int field_1D0;
  int field_1D4;
  char gap_1d8[4];
  int field_1DC;
  int NotIdleStartTime;
  int TimeToIdle;
  int field_1E8;
  char gap_1ec[4];
  int field_1F0;
  char gap_1f4[2048];
  int field_9F4;
  char gap_9f8[36];
  int field_A1C;
  char gap_a20[3020];
  int field_15EC;
  char gap_15f0[60];
  int field_162C;
  int field_1630;
  int field_1634;
  int field_1638;
  int field_163C;
  char gap_1640[8];
  BoundingBox BoundingBox;
  int field_1660;
  char gap_1664[4];
  int ShieldPower;
  char gap_166c[4];
  int NumberOfKills;
  int InflictedDamage;
  int field_1678;
  int field_167C;
  char gap_1680[8];
  __int16 field_1688;
  __int16 field_168A;
  int field_168C;
  int field_1690;
  char field_1694;
  char field_1695;
  __int16 field_1696;
  int field_1698;
  int field_169C;
  char gap_16a0[2];
  int field_16A2;
  char gap_16a6[994];
  char field_1A88;
  char field_1A89;
  char field_1A8A;
  char field_1A8B;
  Vector3 Executor_AimingDirection;
  int field_1A98;
  int field_1A9C;
  int Executor_ActualMovementMode;
  int field_1AA4;
  int field_1AA8;
  int field_1AAC;
  char Executor_HasFacingOverride;
  char gap_1ab1[3];
  int Executor_AimingSpeed;
  char field_1AB8;
  char Executor_HasMoveOverride;
  char gap_1aba[6];
  int field_1AC0;
  int field_1AC4;
  int Executor_FacingOverride;
  char Executor_HasAttackOverride;
  char gap_1acd[1];
  __int16 field_1ACE;
  __int16 field_1AD0;
  char gap_1ad2[6];
  int field_1AD8;
  int field_1ADC;
  int field_1AE0;
  int field_1AE4;
  char Executor_HasThrowOverride;
  char gap_1ae9[3];
  int field_1AEC;
  int field_1AF0;
  int field_1AF4;
  void* Animation;
  __int16 AnimationToState;
  __int16 AnimationFromState;
  __int16 AnimationType;
  __int16 NextAnimationType;
  __int16 PrevAnimationType;
  __int16 field_1B06;
  char Stitch;
  char gap_1b09[3];
  int StitchHeight;
  __int16 InterpolationFromState;
  char gap_1b12[2];
  Vector3 StitchVelocity;
  __int16 InterpolationCurrentFrame;
  __int16 InterpolationLength;
  Quaternion InterpolationStartRotations[19];
  char gap_1c54[4];
  int field_1C58;
  int field_1C5C;
  int field_1C60;
  int Overlay;
  __int16 field_1C68;
  __int16 field_1C6A;
  int field_1C6C;
  int field_1C70;
  __int16 field_1C74;
  char gap_1c76[2];
  int field_1C78;
  char gap_1c7c[12];
  __int16 Frame;
  __int16 SoftPause;
  __int16 HardPause;
  __int16 field_1C8E;
  int ForcedAnimationFrames;
  __int16 HitStun;
  __int16 BlockStun;
  __int16 Dizzy;
  __int16 field_1C9A;
  int field_1C9C;
  __int16 AnimationVariant;
  __int16 TimeToPeace;
  char NumAnimationAttachedParticles;
  char gap_1ca5[1];
  __int16 field_1CA6;
  AttachedParticle AnimationAttachedParticles[16];
  int TRAMParticles;
  char FixedParticlesAttached;
  char FixedParticlesStarted;
  __int16 NumFixedParticles;
  AttachedParticle FixedParticles[16];
  __int16 CurrentAnimationType;
  char gap_1eb2[2];
  int field_1EB4;
  char field_1EB8;
  char gap_1eb9[30];
  char field_1ED7;
  __int16 throwing;
  __int16 thrownBy;
  Character* ThrowTargetCharacter;
  void* targetThrow; //animation
  int field_1EE4;
  int field_1EE8;
  int field_1EEC;
  Quaternion Rotations[19];
  Quaternion OverlayRotations[19];
  int field_2150;
  char gap_2154[4];
  GameInput Input;
  int PrevActions1;
  int PrevActions2;
  int SprintTimer;
  char field_2194;
  char field_2195;
  char gap_2196[2];
  Vector3 AimTarget;
  Vector3 AimVector;
  Vector3 CamVector;
  float HeadFacing;
  float HeadPitch;
  int field_21C4;
  int field_21C8;
  int field_21CC;
  int field_21D0;
  char field_21D4;
  char gap_21d5[3];
  int field_21D8;
  char field_21DC;
  char field_21DD;
  char field_21DE;
  char field_21DF;
  char field_21E0;
  char HasAlternateTrigger;
  char field_21E2;
  char ReleaseTrigger;
  char ReleaseAlternateTrigger;
  char TurningLeft;
  char TurningRight;
  char gap_21e7[1];
  int field_21E8;
  int field_21EC;
  __int16 field_21F0;
  char gap_21f2[2];
  PlayingFilm PlayingFilm;
  char gap_2218[4];
  int field_221C;
  char gap_2220[8];
  Matrix4x3  * ExtraBody;
  char gap_222c[76];
  Matrix4x3 BoneMatrices[19];
  Matrix4x3 WeaponMatrix;
  char gap_2638[432];
  int field_27E8;
  char gap_27ec[4];
  __int16 field_27F0;
  __int16 field_27F2;
  int field_27F4;
  int field_27F8;
  __int16 ShadowIndex;
  char field_27FE;
  char gap_27ff[1];
  char field_2800;
  char field_2801;
  char ShieldParts[19];
  char field_2815;
  char gap_2816[2];
  int field_2818;
  __int16 field_281C;
  char gap_281e[2];
  int field_2820;
  int field_2824;
  int field_2828;
  int field_282C;
  __int16 field_2830;
  __int16 field_2832;
  char gap_2834[1];
  char field_2835;
  char field_2836;
  char field_2837;
} ActiveCharacter;

typedef struct
{
	char name[64];	// Must be same as ONcMaxLevelName above (for TE)
	
	void *env;
	void *objectsetup;
	void *markers;
	void *flags;
	void *triggers;
	
	void *Sky;
	float	SkyHeight;


} OniLevel;

typedef struct
{
  int TimerMode;
  char TimerName[32];
  int TimerDuration;
  char field_28;
  char gap_29[3];
  int field_2C;
  Letterbox Letterbox;
  char gap_3a[2];
  char field_3C;
  char gap_3d[3];
  int field_40;
  int CutsceneSyncMark;
  char field_48;
  char gap_49[3];
  int field_4C;
  int field_50;
  int field_54;
  int field_58;
  int field_5C;
  int field_60;
  int field_64;
  int field_68;
  int field_6C;
  int field_70;
  int FadeStartTime;
  int FadeEndTime;
  char field_7C;
  char gap_7d[3];
  int Camera;
  PHGraph PathFindingGraph;
  Character* PlayerCharacter;
  int field_B0;
  char gap_b4[4];
  GameInput Input;
  int field_E8;
  int field_EC;
  char ScreenShotEveryFrame;
  char gap_f1[7];
  char field_F8;
  char field_F9;
  char field_FA;
  char gap_fb[1];
  int field_FC;
  int field_100;
  char field_104;
  char gap_105[3];
  int SlowMotion;
  char gap_10c[4];
  int field_110;
  int field_114;
  char SplashScreenTextureName[32];
  char field_138;
  char gap_139[7];
  int field_140;
  int GameTime;
  int field_148;
  int field_14C;
  OniLevel* Level;
  int field_154;
  MotionBlur MotionBlur_[64];
  int MotionBlurCount;
  __int16 field_125C;
  __int16 field_125E;
  Character CharacterStorage[128];
  __int16 CharacterCount;
  char gap_b6262[2];
  int field_B6264;
  ActiveCharacter ActiveCharacters[64];
  __int16 ActiveCharacterCount;
  Shadow Shadows[32];
  __int16 field_1670EA;
  int ShadowCount;
  int ActiveCharacterList[128];
  int ActiveCharacterListCount;
  int ActiveCharacterListLock;
  int LivingCharacterList[128];
  int LivingCharacterListCount;
  int LivingCharacterListLock;
  Character* PresentCharacterList[128];
  int PresentCharacterListCount;
  int PresentCharacterListLock;
  int ObjectList;
  DoorArray DoorArray_;
  Sky Sky_;
  int field_1679A4;
  int Triggers;
  char IsGamePaused;
  char IsInputEnabled;
  char field_1679AE;
  char gap_1679af[1];
  int LastInputActions1;
  int LastInputActions2;
  int field_1679B8;
  int WinLose;
  int field_1679C0;
  int field_1679C4;
  int field_1679C8;
  int field_1679CC;
  int field_1679D0;
  int field_1679D4;
  __int16 field_1679D8;
  char gap_1679da[2];
  int field_1679DC;
} GameState;


typedef struct 
{
	int			priority;
	int timer;						// amount of time to display the text
	char				prefix[10];	// prefix for the line
	char				text[502];		// text on the line
	const char			*identifier;
	int			text_color;
	int			text_shadow;
} COtTextEntry;

typedef struct 
{
	void		*font_family;
	void *text_context;				// text context to do the drawing
	short			formatting;
	short			font_size;
	char				scale_font;
	char				bottom_justify;
	char				display_completion;
	char				fade_over_bounds;
	char				use_formatting_commands;

	short				bounds[4];
	short			num_text_entries;
	short max_text_entries;
	char pad[3];
	COtTextEntry		*text_entries;				// an array (num_text_entries long) of COtTextEntry
		int blah;
		int blah2;
			int blah3;
} COtTextArea;

#endif

