#include "packagepage3.h"
#include "ui_packagepage3.h"

PackagePage3::PackagePage3(QWidget *parent) :
    QWizardPage(parent),
    ui(new Ui::PackagePage3)
{
    ui->setupUi(this);
    this->setTitle("Optional Fields");
    this->setSubTitle("Separate multiple elements by commas.");

    //Register fields
    registerField("leDependentPackages", ui->leDependent);
    registerField("leIncompatiblePackages", ui->leIncompatible);
    registerField("leUnlockLevels", ui->leUnlockLevels);
}

bool PackagePage3::validatePage(){
    QString dependentPackages=ui->leDependent->text().trimmed();
    QString incompatiblePackages=ui->leIncompatible->text().trimmed();
    QString unlockLevels=ui->leUnlockLevels->text().trimmed();

    if(!validateField(dependentPackages) || !validateField(incompatiblePackages)
            || !validateField(unlockLevels,true)){
        return false;
    }

    return true;
}

bool PackagePage3::validateField(QString &field, bool isLevels){
    //Check if the numbers are correct and correctly separated
    if(!field.isEmpty()){

        QStringList list =Util::substring(field,",");

        for(int i=0; i<list.size(); i++){

            if(list.at(i).isEmpty()){
                Util::showErrorPopUp("There are commas without numbers in their sides.");
                return false;
            }

            if(!Util::isStringInteger(list.at(i))){
                Util::showErrorPopUp("Number is not numeric.");
                return false;
            }

            if(!isLevels){
                if(list.at(i).size()!=5){
                    Util::showErrorPopUp("You have invalid packages numbers. Each number must have 5 digits.");
                    return false;
                }
            }
        }
    }

    return true;
}

PackagePage3::~PackagePage3()
{
    delete ui;
}
