#include "xmlprocessor.h"

XmlProcessor::XmlProcessor(Logger *myLogger, QStringList *commands)
{
    this->myLogger=myLogger;
    this->commands=commands;
}

void XmlProcessor::run()
{
    QProcess *myProcess = new QProcess();
    QString result = QString();
    QString errorMessage = "";
    int numErrors=0;

    for(int i=0; i<this->commands->size(); i++){

        myProcess->start(GlobalVars::XmlToolsExeName+" "+this->commands->at(i));
        myProcess->waitForFinished(-1);
        result=myProcess->readAllStandardError();

        if(!result.isEmpty()){
            //catch exception
            myLogger->writeString("Xml Tools Error: \n"+this->commands->at(i)+"\n"+result);
            errorMessage=result;
            numErrors++;
        }

    }

    delete myProcess; //delete object and make pointer invalid
    this->commands->clear(); //clean list

    //let's cut it a bit, complete error is in log file.
    if(errorMessage.size()>600){
        //limit it at 400 characters (not counting the warning at the begin)
        errorMessage.remove(299,errorMessage.size()-600);
        errorMessage.insert(299,"\n \t ... \n");
        errorMessage.insert(0,"This error was been shortened. \nSee the complete error at Vago log file.\n\n");
    }

    emit resultConversion(errorMessage,numErrors);
}

