#include "packagepagefinal.h"
#include "ui_packagepagefinal.h"

PackagePageFinal::PackagePageFinal(QSettings *vagoSettings, QWidget *parent) :
    QWizardPage(parent),
    ui(new Ui::PackagePageFinal)
{
    ui->setupUi(this);
    this->setTitle("Finished");

    ui->lbComplete->setText("<html>"
                            "The wizard is now complete. The package will be created when you click in finish.<br/>"
                            "After that you can upload the package to <a href='http://"+GlobalVars::ModsDomain+"'>"
                            +GlobalVars::ModsDomain+"</a> to get your mod listed in the AEI."
                            "</html>"); // Don't use rich text in qtdesigner because it generates platform dependent code

    ui->lbComplete->setOpenExternalLinks(true); //allow navigate to mod depot

    //Default checkboxes values
    if(!vagoSettings->contains("PackageCreator/OpenFolder")){
        vagoSettings->setValue("PackageCreator/OpenFolder", true);
    }
    if(!vagoSettings->contains("PackageCreator/CreateZip")){
        vagoSettings->setValue("PackageCreator/CreateZip",true);
    }

    //remember them next time
    ui->cbOpenFolder->setChecked(vagoSettings->value("PackageCreator/OpenFolder").toBool());
    ui->cbCreateZip->setChecked(vagoSettings->value("PackageCreator/CreateZip").toBool());
    registerField("cbOpenFolder", ui->cbOpenFolder);
    registerField("cbCreateZip", ui->cbCreateZip);
}

PackagePageFinal::~PackagePageFinal()
{
    delete ui;
}
