#include "soundpage2.h"
#include "ui_soundpage2.h"

const QStringList SoundPage2::allowedFiles = QStringList() << "*.wav" <<  "*.aif" <<  "*.aifc" << "*.afc";
const QString SoundPage2::codecLocalHelpFile=GlobalVars::HelpLocation + "/XMLSNDD.html#Source_file_creation";

SoundPage2::SoundPage2(QWidget *parent) :
    QWizardPage(parent),
    ui(new Ui::soundpage2)
{
    ui->setupUi(this);
    this->soundTable=ui->twSoundFiles;
    ui->twSoundFiles->removeColumn(2); // Only two columns

    ui->label->setText("<html>Add here the files you want to convert. "
                       "All the files will have the same properties applied.<br/>"
                       "Don't forget to first convert the files to an oni compatible codec. "
                       "More information <a href=' '>here.</a></html>"); // Don't use rich text in qtdesigner because it generates platform dependent code

    // Drop signal for Packages table
    connect(ui->twSoundFiles, SIGNAL(dropped(DropTableWidget*,QStringList)), this, SLOT(addResourcesSounds(DropTableWidget*,QStringList)));
    // Signal for click in label (display local help)
    connect(ui->label, SIGNAL(linkActivated(const QString & )), this, SLOT(openCodecLocalHelp()));

    //Register fields to be accessible in another pages
    registerField("rbOther", ui->rbOther);
    registerField("leOtherLocation", ui->leOtherLocation);
}

SoundPage2::~SoundPage2()
{
    delete ui;
}

void SoundPage2::on_rbOther_toggled(bool checked)
{
    if(checked){
        ui->leOtherLocation->setEnabled(true);
        ui->pbBrowserOtherLocation->setEnabled(true);
        return;
    }

    ui->leOtherLocation->setEnabled(false);
    ui->pbBrowserOtherLocation->setEnabled(false);
}

void SoundPage2::on_tbAddFiles_clicked()
{
    addResourcesSounds(ui->twSoundFiles,QFileDialog::getOpenFileNames(this,"Choose the sound files...","./" , "Audio (" + this->allowedFiles.join(" ") + ")"));
}

void SoundPage2::on_tbRemoveFiles_clicked()
{
    int size = ui->twSoundFiles->selectionModel()->selectedRows().size();

    if(size==0){
        Util::showPopUp("Select a row first.");
        return;
    }

    if(Util::showQuestionPopUp(this,"Are you sure you want to delete the selected rows?")){
        for(int i=0; i<size; i++){
            ui->twSoundFiles->removeRow(ui->twSoundFiles->selectionModel()->selectedRows().at(size-i-1).row());
        }
    }
}

void SoundPage2::addResourcesSounds(DropTableWidget *myTable, QStringList resources){

    bool fileExtValid=false;

    //Pre-processing (check if received only folders)
    foreach(QString myFile, resources){
        QString currFileExt=QFileInfo(myFile).completeSuffix();
        if(QDir(myFile).exists()){
            Util::showErrorPopUp("Only files are allowed for this operation.");
            return;
        }

        foreach(QString vext, this->allowedFiles){
            vext.remove("*.");
            if(vext==currFileExt){
                fileExtValid=true;
                break;
            }
        }

        if(!fileExtValid){
            Util::showErrorPopUp("Files must be in the follow formats:\n" +
                                 this->allowedFiles.join(" "));
            return;
        }
    }

    foreach(QString currentFile, resources){

        //Get actual number rows
        int twSize=myTable->rowCount();

        //increase the rows for the new item
        myTable->setRowCount(twSize+1);

        //Add to table and list to
        QTableWidgetItem *newName = new QTableWidgetItem(QFileInfo(currentFile).baseName());
        QTableWidgetItem *newFileLocation = new QTableWidgetItem(Util::normalizePath(currentFile));

        myTable->setItem(twSize,0,newName);
        myTable->setItem(twSize,1,newFileLocation);
        myTable->updateTableToolTips(twSize); //Update tool tips
    }
}

void SoundPage2::on_pbBrowserOtherLocation_clicked()
{
    ui->leOtherLocation->setText(QFileDialog::getExistingDirectory(this,"Choose output folder..."));
}

void SoundPage2::openCodecLocalHelp(){
    QDesktopServices::openUrl(QUrl("file:///"+this->codecLocalHelpFile));
}

bool SoundPage2::validatePage(){

    QStringList namesList;

    if(ui->twSoundFiles->rowCount()==0){
        Util::showErrorPopUp("You need to add some sound files first!");
        return false;
    }

    for(int i=0; i<ui->twSoundFiles->rowCount(); i++){
        namesList << ui->twSoundFiles->item(i,0)->text();
    }

    if(ui->rbOther->isChecked() && Util::checkEmptySpaces(QStringList() << ui->leOtherLocation->text())){
        Util::showErrorPopUp("Please input a directory to output the files.");
        return false;
    }

    if(ui->rbOther->isChecked() && !QDir(ui->leOtherLocation->text()).exists()){
        Util::showErrorPopUp("Invalid directory specified in other location. Please fix it.");
        return false;
    }

    return true;
}
