package net.oni2.aeinstaller.backend.oni.management.tools;

import java.io.File;

import net.oni2.aeinstaller.backend.CaseInsensitiveFile;
import net.oni2.aeinstaller.backend.Paths;
import net.oni2.aeinstaller.backend.packages.Package;
import net.oni2.platformtools.PlatformInformation;
import net.oni2.platformtools.PlatformInformation.Platform;

/**
 * @author Christian Illy
 */
public class ToolFileIterator {

	/**
	 * Iterate over tool package files with source and respective target file
	 * 
	 * @param tool
	 *            Tool to iterate over
	 * @param handler
	 *            Handler to handle found files
	 */
	public static void iteratePlatformToolFiles(Package tool,
			ToolFileIteratorEntry handler) {
		File plain = CaseInsensitiveFile.getCaseInsensitiveFile(
				tool.getLocalPath(), "plain");
		if (plain.exists()) {
			if (tool.hasSeparatePlatformDirs()) {
				File plainCommon = CaseInsensitiveFile.getCaseInsensitiveFile(
						plain, "common");
				File plainMac = CaseInsensitiveFile.getCaseInsensitiveFile(
						plain, "mac_only");
				File plainWin = CaseInsensitiveFile.getCaseInsensitiveFile(
						plain, "win_only");
				if (plainCommon.exists())
					iterateFiles(plainCommon, Paths.getEditionBasePath(),
							handler);
				if (PlatformInformation.getPlatform() == Platform.MACOS
						&& plainMac.exists())
					iterateFiles(plainMac, Paths.getEditionBasePath(), handler);
				else if (plainWin.exists())
					iterateFiles(plainWin, Paths.getEditionBasePath(), handler);
			} else {
				iterateFiles(plain, Paths.getEditionBasePath(), handler);
			}
		}
	}

	private static void iterateFiles(File srcFolder, File targetFolder,
			ToolFileIteratorEntry handler) {
		for (File f : srcFolder.listFiles()) {
			if (f.isDirectory())
				iterateFiles(f, CaseInsensitiveFile.getCaseInsensitiveFile(
						targetFolder, f.getName()), handler);
			else {
				handler.toolFile(f, new File(targetFolder, f.getName()));
			}
		}
	}

}
