package net.oni2.aeinstaller.backend.oni.management;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.TreeSet;

import net.oni2.aeinstaller.backend.Paths;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.StaxDriver;

/**
 * @author Christian Illy
 */
public class ModInstallationList {
	private static ModInstallationList instance = loadList();

	private TreeSet<Integer> mods = new TreeSet<Integer>();
	private HashSet<String> affectedLevels = new HashSet<String>();
	private transient boolean isLoaded = false;

	/**
	 * @return Get singleton instance
	 */
	public static ModInstallationList getInstance() {
		return instance;
	}
	
	public TreeSet<Integer> getInstalledMods() {
		return mods;
	}
	
	public boolean isInstalled(int packageId) {
		return mods.contains(packageId);
	}
	
	public void setInstalledMods(TreeSet<Integer> mods) {
		this.mods = mods;
	}
	
	public HashSet<String> getAffectedLevels() {
		return affectedLevels;
	}
	
	public boolean isLevelAffected(String level) {
		return affectedLevels.contains(level.toLowerCase());
	}
	
	public void setAffectedLevels(HashSet<String> levels) {
		affectedLevels.clear();
		for (String l : levels) {
			affectedLevels.add(l.toLowerCase());
		}
	}
	
	public boolean isLoadedFromFile() {
		return isLoaded;
	}

	private static File getFile() {
		return new File(Paths.getEditionGDF(), "installed_mods.xml");
	}

	private static XStream getStream() {
		XStream xs = new XStream(new StaxDriver());
		xs.alias("MIL", ModInstallationList.class);
		return xs;
	}

	private static ModInstallationList loadList() {
		ModInstallationList mil = new ModInstallationList();
		try {
			if (getFile().exists()) {
				FileInputStream fis = new FileInputStream(getFile());
				XStream xs = getStream();
				Object obj = xs.fromXML(fis);
				if (obj instanceof ModInstallationList) {
					mil = (ModInstallationList) obj;
					mil.isLoaded = true;
				}
				fis.close();
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return mil;
	}

	/**
	 * Write this mod installation list to the installed_mods.xml file
	 */
	public void saveList() {
		try {
			FileOutputStream fos = new FileOutputStream(getFile());
			XStream xs = getStream();
			xs.toXML(this, fos);
			fos.close();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
