/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.ByteBufferInputStream;
import com.sun.net.ssl.internal.ssl.CipherBox;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.InputRecord;
import com.sun.net.ssl.internal.ssl.MAC;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.SSLEngineImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.crypto.BadPaddingException;
import javax.net.ssl.SSLException;
import sun.misc.HexDumpEncoder;

final class EngineInputRecord
extends InputRecord {
    private SSLEngineImpl engine;
    private static ByteBuffer tmpBB = ByteBuffer.allocate(0);
    private boolean internalData;

    EngineInputRecord(SSLEngineImpl sSLEngineImpl) {
        this.engine = sSLEngineImpl;
    }

    byte contentType() {
        if (this.internalData) {
            return super.contentType();
        }
        return 23;
    }

    int bytesInCompletePacket(ByteBuffer byteBuffer) throws SSLException {
        if (byteBuffer.remaining() < 5) {
            return -1;
        }
        int n = byteBuffer.position();
        byte by = byteBuffer.get(n);
        int n2 = 0;
        if (this.formatVerified || by == 22 || by == 21) {
            ProtocolVersion protocolVersion = ProtocolVersion.valueOf(byteBuffer.get(n + 1), byteBuffer.get(n + 2));
            if (protocolVersion.v < ProtocolVersion.MIN.v || protocolVersion.major > ProtocolVersion.MAX.major) {
                throw new SSLException("Unsupported record version " + protocolVersion);
            }
            this.formatVerified = true;
            n2 = ((byteBuffer.get(n + 3) & 0xFF) << 8) + (byteBuffer.get(n + 4) & 0xFF) + 5;
        } else {
            boolean bl;
            boolean bl2 = bl = (by & 0x80) != 0;
            if (bl && (byteBuffer.get(n + 2) == 1 || byteBuffer.get(n + 2) == 4)) {
                ProtocolVersion protocolVersion = ProtocolVersion.valueOf(byteBuffer.get(n + 3), byteBuffer.get(n + 4));
                if ((protocolVersion.v < ProtocolVersion.MIN.v || protocolVersion.major > ProtocolVersion.MAX.major) && protocolVersion.v != ProtocolVersion.SSL20Hello.v) {
                    throw new SSLException("Unsupported record version " + protocolVersion);
                }
                int n3 = bl ? 127 : 63;
                n2 = ((by & n3) << 8) + (byteBuffer.get(n + 1) & 0xFF) + (bl ? 2 : 3);
            } else {
                throw new SSLException("Unrecognized SSL message, plaintext connection?");
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkMAC(MAC mAC, ByteBuffer byteBuffer) {
        if (this.internalData) {
            return this.checkMAC(mAC);
        }
        int n = mAC.MAClen();
        if (n == 0) {
            return true;
        }
        int n2 = byteBuffer.limit();
        int n3 = n2 - n;
        byteBuffer.limit(n3);
        byte[] byArray = mAC.compute(this.contentType(), byteBuffer);
        if (n != byArray.length) {
            throw new RuntimeException("Internal MAC error");
        }
        byteBuffer.position(n3);
        byteBuffer.limit(n2);
        try {
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                if (byteBuffer.get() == byArray[n4]) continue;
                boolean bl = false;
                return bl;
            }
            n4 = 1;
            return n4 != 0;
        }
        finally {
            byteBuffer.rewind();
            byteBuffer.limit(n3);
        }
    }

    ByteBuffer decrypt(CipherBox cipherBox, ByteBuffer byteBuffer) throws BadPaddingException {
        if (this.internalData) {
            this.decrypt(cipherBox);
            return tmpBB;
        }
        cipherBox.decrypt(byteBuffer);
        byteBuffer.rewind();
        return byteBuffer.slice();
    }

    void writeBuffer(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = (ByteBuffer)ByteBuffer.allocate(n2).put(byArray, 0, n2).flip();
        this.engine.writer.putOutboundDataSync(byteBuffer);
    }

    ByteBuffer read(ByteBuffer byteBuffer) throws IOException {
        Object object;
        if (!this.formatVerified || byteBuffer.get(byteBuffer.position()) != 23) {
            this.internalData = true;
            this.read(new ByteBufferInputStream(byteBuffer), null);
            return tmpBB;
        }
        this.internalData = false;
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        ProtocolVersion protocolVersion = ProtocolVersion.valueOf(byteBuffer.get(n + 1), byteBuffer.get(n + 2));
        if (protocolVersion.v < ProtocolVersion.MIN.v || protocolVersion.major > ProtocolVersion.MAX.major) {
            throw new SSLException("Unsupported record version " + protocolVersion);
        }
        int n3 = this.bytesInCompletePacket(byteBuffer);
        assert (n3 > 0);
        if (debug != null && Debug.isOn("packet")) {
            try {
                object = new HexDumpEncoder();
                byteBuffer.limit(n + n3);
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                System.out.println("[Raw read (bb)]: length = " + n3);
                object.encodeBuffer(byteBuffer2, (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        byteBuffer.position(n + 5);
        byteBuffer.limit(n + n3);
        object = byteBuffer.slice();
        byteBuffer.position(byteBuffer.limit());
        byteBuffer.limit(n2);
        return object;
    }
}

