/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import sun.misc.PerformanceLogger;

public final class PerfLogger {
    private static boolean perfLogOn = false;
    private static String perfLogFilePath = null;
    private static long baseTime = 0L;
    private static long endTime = 0L;

    public static void setBaseTimeString(String string) {
        if (string != null) {
            try {
                long l = new Long(string);
                baseTime = l + Config.getInstance().getSysStartupTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean perfLogEnabled() {
        return perfLogOn;
    }

    public static void setStartTime(String string) {
        if (perfLogOn) {
            if (baseTime == 0L) {
                baseTime = System.currentTimeMillis();
            }
            PerformanceLogger.setStartTime((String)string, (long)baseTime);
        }
    }

    public static void setTime(String string) {
        if (perfLogOn) {
            PerformanceLogger.setTime((String)string);
        }
    }

    public static void setEndTime(String string) {
        if (perfLogOn) {
            PerformanceLogger.setTime((String)string);
            endTime = System.currentTimeMillis();
        }
    }

    public static void outputLog() {
        try {
            PerformanceLogger.setBaseTime((long)baseTime);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (perfLogOn) {
            if (endTime != 0L) {
                PerformanceLogger.setTime((String)("Deployment Java Startup time " + (endTime - PerformanceLogger.getStartTime())));
            }
            PerformanceLogger.outputLog();
        }
    }

    static {
        perfLogFilePath = System.getProperty("sun.perflog");
        if (perfLogFilePath != null && Config.isJavaVersionAtLeast15()) {
            perfLogOn = true;
        }
    }
}

