/*
 * Decompiled with CFR 0.152.
 */
package sun.util;

import java.lang.ref.SoftReference;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.spi.TimeZoneNameProvider;
import sun.util.LocaleServiceProviderPool;
import sun.util.calendar.ZoneInfo;
import sun.util.resources.LocaleData;
import sun.util.resources.OpenListResourceBundle;

public final class TimeZoneNameUtility {
    private static ConcurrentHashMap<Locale, SoftReference<OpenListResourceBundle>> cachedBundles = new ConcurrentHashMap();
    private static ConcurrentHashMap<Locale, SoftReference<String[][]>> cachedZoneData = new ConcurrentHashMap();

    public static final String[][] getZoneStrings(Locale locale) {
        String[][] stringArray;
        SoftReference<String[][]> softReference = cachedZoneData.get(locale);
        if (softReference == null || (stringArray = softReference.get()) == null) {
            stringArray = TimeZoneNameUtility.loadZoneStrings(locale);
            softReference = new SoftReference<String[][]>(stringArray);
            cachedZoneData.put(locale, softReference);
        }
        return stringArray;
    }

    private static final String[][] loadZoneStrings(Locale locale) {
        String[][] stringArrayArray;
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        OpenListResourceBundle openListResourceBundle = TimeZoneNameUtility.getBundle(locale);
        Enumeration<String> enumeration = openListResourceBundle.getKeys();
        String[] stringArray = null;
        while (enumeration.hasMoreElements()) {
            stringArrayArray = enumeration.nextElement();
            stringArray = TimeZoneNameUtility.retrieveDisplayNames(openListResourceBundle, (String)stringArrayArray, locale);
            if (stringArray == null) continue;
            linkedList.add(stringArray);
        }
        stringArrayArray = new String[linkedList.size()][];
        return (String[][])linkedList.toArray((T[])stringArrayArray);
    }

    public static final String[] retrieveDisplayNames(String string, Locale locale) {
        OpenListResourceBundle openListResourceBundle = TimeZoneNameUtility.getBundle(locale);
        return TimeZoneNameUtility.retrieveDisplayNames(openListResourceBundle, string, locale);
    }

    private static final String[] retrieveDisplayNames(OpenListResourceBundle openListResourceBundle, String string, Locale locale) {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(TimeZoneNameProvider.class);
        String[] stringArray = null;
        if (localeServiceProviderPool.hasProviders()) {
            stringArray = localeServiceProviderPool.getLocalizedObject(TimeZoneNameGetter.INSTANCE, locale, openListResourceBundle, string, new Object[0]);
        }
        if (stringArray == null) {
            try {
                stringArray = openListResourceBundle.getStringArray(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return stringArray;
    }

    private static final OpenListResourceBundle getBundle(Locale locale) {
        OpenListResourceBundle openListResourceBundle;
        SoftReference<OpenListResourceBundle> softReference = cachedBundles.get(locale);
        if (softReference == null || (openListResourceBundle = softReference.get()) == null) {
            openListResourceBundle = LocaleData.getTimeZoneNames(locale);
            softReference = new SoftReference<OpenListResourceBundle>(openListResourceBundle);
            cachedBundles.put(locale, softReference);
        }
        return openListResourceBundle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TimeZoneNameGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<TimeZoneNameProvider, String[]> {
        private static final TimeZoneNameGetter INSTANCE = new TimeZoneNameGetter();

        private TimeZoneNameGetter() {
        }

        @Override
        public String[] getObject(TimeZoneNameProvider timeZoneNameProvider, Locale locale, String string, Object ... objectArray) {
            assert (objectArray.length == 0);
            String[] stringArray = null;
            String string2 = string;
            if (string2.equals("GMT")) {
                stringArray = TimeZoneNameGetter.buildZoneStrings(timeZoneNameProvider, locale, string2);
            } else {
                Map<String, String> map = ZoneInfo.getAliasTable();
                if (map != null) {
                    if (map.containsKey(string2)) {
                        String string3 = string2;
                        while ((string2 = map.get(string2)) != null) {
                            string3 = string2;
                        }
                        string2 = string3;
                    }
                    if ((stringArray = TimeZoneNameGetter.buildZoneStrings(timeZoneNameProvider, locale, string2)) == null) {
                        stringArray = TimeZoneNameGetter.examineAliases(timeZoneNameProvider, locale, string2, map, map.entrySet());
                    }
                }
            }
            if (stringArray != null) {
                stringArray[0] = string;
            }
            return stringArray;
        }

        private static String[] examineAliases(TimeZoneNameProvider timeZoneNameProvider, Locale locale, String string, Map<String, String> map, Set<Map.Entry<String, String>> set) {
            if (map.containsValue(string)) {
                for (Map.Entry<String, String> entry : set) {
                    if (!entry.getValue().equals(string)) continue;
                    String string2 = entry.getKey();
                    String[] stringArray = TimeZoneNameGetter.buildZoneStrings(timeZoneNameProvider, locale, string2);
                    if (stringArray != null) {
                        return stringArray;
                    }
                    stringArray = TimeZoneNameGetter.examineAliases(timeZoneNameProvider, locale, string2, map, set);
                    if (stringArray == null) continue;
                    return stringArray;
                }
            }
            return null;
        }

        private static String[] buildZoneStrings(TimeZoneNameProvider timeZoneNameProvider, Locale locale, String string) {
            String[] stringArray = new String[5];
            for (int i = 1; i <= 4; ++i) {
                stringArray[i] = timeZoneNameProvider.getDisplayName(string, i >= 3, i % 2, locale);
                if (i < 3 || stringArray[i] != null) continue;
                stringArray[i] = stringArray[i - 2];
            }
            if (stringArray[1] == null) {
                stringArray = null;
            }
            return stringArray;
        }
    }
}

