/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.BasicHttpResponse;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.URLUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public final class BasicHttpRequest
implements HttpRequest {
    private static final String USER_AGENT_JAVA_VERSION = "UA-Java-Version";
    private static final String USER_AGENT = "User-Agent";
    private static String[] fieldName = new String[]{"content-length", "last-modified", "expires", "content-type", "content-encoding", "date", "server", "x-java-jnlp-version-id", "pragma", "cache-control"};

    public static boolean isHeaderFieldCached(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < fieldName.length; ++i) {
            if (!string.equalsIgnoreCase(fieldName[i])) continue;
            return true;
        }
        return false;
    }

    public HttpResponse doGetRequestEX(URL uRL, long l) throws IOException {
        return this.doRequest(uRL, false, null, null, true, l);
    }

    public HttpResponse doGetRequestEX(URL uRL, String[] stringArray, String[] stringArray2, long l) throws IOException {
        return this.doRequest(uRL, false, stringArray, stringArray2, true, l);
    }

    public HttpResponse doGetRequest(URL uRL) throws IOException {
        return this.doRequest(uRL, false, null, null, true);
    }

    public HttpResponse doGetRequest(URL uRL, boolean bl) throws IOException {
        return this.doRequest(uRL, false, null, null, bl);
    }

    public HttpResponse doHeadRequest(URL uRL) throws IOException {
        return this.doRequest(uRL, !Environment.isJavaPlugin(), null, null, true);
    }

    public HttpResponse doHeadRequest(URL uRL, boolean bl) throws IOException {
        return this.doRequest(uRL, true, null, null, bl);
    }

    public HttpResponse doGetRequest(URL uRL, String[] stringArray, String[] stringArray2) throws IOException {
        return this.doRequest(uRL, false, stringArray, stringArray2, true);
    }

    public HttpResponse doGetRequest(URL uRL, String[] stringArray, String[] stringArray2, boolean bl) throws IOException {
        return this.doRequest(uRL, false, stringArray, stringArray2, bl);
    }

    public HttpResponse doHeadRequest(URL uRL, String[] stringArray, String[] stringArray2) throws IOException {
        return this.doRequest(uRL, true, stringArray, stringArray2, true);
    }

    public HttpResponse doHeadRequest(URL uRL, String[] stringArray, String[] stringArray2, boolean bl) throws IOException {
        return this.doRequest(uRL, true, stringArray, stringArray2, bl);
    }

    private HttpResponse doRequest(URL uRL, boolean bl, String[] stringArray, String[] stringArray2, boolean bl2) throws IOException {
        return this.doRequest(uRL, bl, stringArray, stringArray2, bl2, 0L);
    }

    private HttpResponse doRequest(URL uRL, boolean bl, String[] stringArray, String[] stringArray2, boolean bl2, long l) throws IOException {
        MessageHeader messageHeader;
        String string;
        String string2;
        Object object;
        Object object2;
        long l2 = 0L;
        String string3 = null;
        if ("file".equals(uRL.getProtocol()) && uRL.getFile() != null) {
            try {
                object2 = URLUtil.getPathFromURL(uRL);
                object = new File((String)object2);
                l2 = ((File)object).lastModified();
                if (((String)object2).endsWith(".jnlp")) {
                    string3 = "application/x-java-jnlp-file";
                } else if (((String)object2).endsWith(".jardiff")) {
                    string3 = "application/x-java-archive-diff";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object2 = null;
        object2 = uRL.getProtocol().equals("file") ? this.createUrlConnection(HttpUtils.removeQueryStringFromURL(uRL), bl, stringArray, stringArray2, bl2) : this.createUrlConnection(uRL, bl, stringArray, stringArray2, bl2);
        object = null;
        if (object2 instanceof HttpURLConnection) {
            object = (HttpURLConnection)object2;
        }
        URLUtil.setHostHeader((URLConnection)object2);
        ((URLConnection)object2).setUseCaches(false);
        ((URLConnection)object2).setIfModifiedSince(l);
        boolean bl3 = false;
        if (Environment.getImportModeCodebase() == null && Environment.getImportModeCodebaseOverride() == null && object2 instanceof HttpURLConnection) {
            object2 = HttpUtils.followRedirects((URLConnection)object2);
            bl3 = true;
        }
        if (!bl3) {
            ((URLConnection)object2).connect();
        }
        int n = 200;
        if (object != null) {
            n = ((HttpURLConnection)object).getResponseCode();
        }
        if (Trace.isTraceLevelEnabled(TraceLevel.NETWORK)) {
            Trace.println(ResourceManager.getString("basicHttpRequest.responseCode", uRL == null ? "" : uRL.toString(), String.valueOf(n)), TraceLevel.NETWORK);
        }
        int n2 = ((URLConnection)object2).getContentLength();
        long l3 = l2 != 0L ? l2 : ((URLConnection)object2).getLastModified();
        long l4 = ((URLConnection)object2).getExpiration();
        String string4 = string2 = string3 != null ? string3 : ((URLConnection)object2).getContentType();
        if (string2 != null && string2.indexOf(59) != -1) {
            string2 = string2.substring(0, string2.indexOf(59)).trim();
        }
        if ((string = (messageHeader = BasicHttpRequest.initializeHeaderFields((URLConnection)object2)).findValue("content-encoding")) != null) {
            string = string.toLowerCase();
        }
        if (Trace.isTraceLevelEnabled(TraceLevel.NETWORK)) {
            Trace.println(ResourceManager.getString("basicHttpRequest.encoding", uRL == null ? "" : uRL.toString(), string), TraceLevel.NETWORK);
        }
        BufferedInputStream bufferedInputStream = null;
        bufferedInputStream = bl ? null : new BufferedInputStream(((URLConnection)object2).getInputStream());
        return new BasicHttpResponse(uRL, n, n2, l4, l3, string2, messageHeader, bufferedInputStream, (HttpURLConnection)object, string);
    }

    public static MessageHeader initializeHeaderFields(URLConnection uRLConnection) throws IOException {
        MessageHeader messageHeader = new MessageHeader();
        String string = uRLConnection.getHeaderFieldKey(0);
        String string2 = uRLConnection.getHeaderField(0);
        if (null == string && null != string2) {
            messageHeader.add(null, string2);
        }
        for (int i = 0; i < fieldName.length; ++i) {
            String string3 = uRLConnection.getHeaderField(fieldName[i]);
            if (string3 == null) continue;
            if (string3.equalsIgnoreCase("application/x-java-archive-diff")) {
                string3 = "application/java-archive";
            }
            messageHeader.add(fieldName[i], string3);
        }
        return messageHeader;
    }

    private URLConnection createUrlConnection(URL uRL, boolean bl, String[] stringArray, String[] stringArray2, boolean bl2) throws MalformedURLException, IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (bl2) {
            String string = "gzip";
            String string2 = HttpUtils.removeQueryStringFromURL(uRL).toString().toLowerCase();
            if (string2.endsWith(".jar") || string2.endsWith(".jarjar")) {
                this.addToRequestProperty(uRLConnection, "content-type", "application/x-java-archive");
                if (DownloadEngine.isPack200Supported()) {
                    string = "pack200-gzip," + string;
                }
            }
            this.addToRequestProperty(uRLConnection, "accept-encoding", string);
        }
        if (System.getProperty("http.agent") == null) {
            uRLConnection.setRequestProperty(USER_AGENT, Environment.getUserAgent());
            uRLConnection.setRequestProperty(USER_AGENT_JAVA_VERSION, Config.getJavaVersion());
        }
        if (stringArray != null && stringArray2 != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                uRLConnection.setRequestProperty(stringArray[i], stringArray2[i]);
            }
        }
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).setRequestMethod(bl ? "HEAD" : "GET");
        }
        return uRLConnection;
    }

    private void addToRequestProperty(URLConnection uRLConnection, String string, String string2) {
        String string3 = uRLConnection.getRequestProperty(string);
        string3 = string3 == null || string3.trim().length() == 0 ? string2 : string3 + "," + string2;
        uRLConnection.setRequestProperty(string, string3);
    }
}

