#include <windows.h>
#include <string.h>
#include <stdio.h>

#include "Daodan.h"
#include "Daodan_Patch.h"
#include "Daodan_Utility.h"
#include "Daodan_Win32.h"
#include "Daodan_Cheater.h"
#include "Daodan_Persistence.h"
#include "Daodan_BSL.h"
#include "Daodan_Console.h"
#include "Daodan_Config.h"

#include "Oni.h"

#include "Oni_GL.h"
#include "Daodan_GL.h"

HMODULE DDrDLLModule;
HMODULE DDrONiModule;

typedef int (__cdecl *CHINESEPROC)(DWORD ThreadId); 

// Hooked WMrSlider_SetRange() in ONiOGU_Options_InitDialog. Disables a gamma
// slider in windowed mode.
static void ONICALL DD_ONiOGU_GammaSlider_SetRange(WMtWindow* window, int min_value, int max_value)
{
	WMrWindow_SetEnabled(window, M3gResolutionSwitch && opt_gamma);
	WMrSlider_SetRange(window, min_value, max_value);
}
 
void ONICALL DDrShowResumeButton(WMtWindow* window, int visibility)
{
	if (visibility)
		WMrWindow_SetLocation(window, 150, 350);
	WMrWindow_SetVisible(window, visibility);
}


/* Options always visible patch */
void ONICALL DDrShowOptionsButton(WMtWindow* window, int visibility)
{
	WMrWindow_SetVisible(window, 1);
}

void ONICALL DDrGame_Init()
{
	if (opt_usedaodanbsl)
		SLrDaodan_Initialize();
}


//this was broken 
FILE** _UUgError_WarningFile = (FILE**)0x005711B4;
FILE *__fastcall DDrPrintWarning(int filename, int linenumber, unsigned __int16 errornum, int message)
{

	FILE *v4; // eax@1
	FILE *result; // eax@4
	char v6[512]; // [sp+0h] [bp-100h]@1
	FILE* UUgError_WarningFile = *_UUgError_WarningFile;

	if (filename && message && (strlen((const char*)filename)+strlen((const char*)message))<420) {
		sprintf(
			v6,
			"Error %x reported from File: %s, Line: %d (message follows) \r\n%s",
			errornum,
			(const char*)filename,
			linenumber,
			(const char*)message);

		if ( UUgError_WarningFile 
			|| (UUgError_WarningFile = oni_fopen("debugger.txt", "wb"), UUgError_WarningFile ) )
		{ 
			oni_fprintf(UUgError_WarningFile, "%s\r\n", v6);
			oni_fflush(UUgError_WarningFile);
		}
	}
	//oni_fprintf(stdout, v6);
	//sprintf(&v6, "%s", message);
	*_UUgError_WarningFile = UUgError_WarningFile;
	result = UUgError_WarningFile;
	return result; 
}


bool DDrPatch_Init()
{
	DDrStartupMessage("Daodan: Patching engine");
	
	// Font texture cache doubled
	if (patch_fonttexturecache)
	{
		DDrPatch_Byte((char*)(OniExe + 0x00020ea7), 0x20);
		DDrPatch_Byte((char*)(OniExe + 0x00020f4a), 0x40);
	}
	
	// Now supports textures up to 512x512
	if (patch_largetextures)
		DDrPatch_Byte  ((char*)(OniExe + 0x00005251), 0x10);
	
	// Non-"_Final" levels are now valid
	if (patch_levelplugins)
		DDrPatch_Byte  ((char*)(OniExe + 0x000206a8), 0x01);
	
	// Pathfinding grid cache size x8
	if (patch_pathfinding)
	{
		const unsigned char pathfinding[2] = {0x90 , 0xE9 };
		DDrPatch_Byte  ((char*)(OniExe + 0x0010b03b), 0x20);
		DDrPatch_Byte  ((char*)(OniExe + 0x0010b04c), 0x20);

		//other stuff
		DDrPatch_Const((char*)(OniExe + 0x00040789), pathfinding);
	}
	
	// Projectile awareness fixed
	if (patch_projaware)
	{
		DDrPatch_Byte  ((char*)(OniExe + 0x0009c07c), 0x6c);
		DDrPatch_Byte  ((char*)(OniExe + 0x0009c080), 0x70);
		DDrPatch_Byte  ((char*)(OniExe + 0x0009c084), 0x74);
		DDrPatch_Byte  ((char*)(OniExe + 0x0009c110), 0x6c);
	}
	
	// Forced DirectInput (for Windows NT)
	if (patch_directinput)
		DDrPatch_Byte((char*)(OniExe + 0x00002e6d), 0xeb);

	if (patch_wpfadetime)
	{
		// Makes wp_fadetime actually have a function
		const unsigned char fadetime_patch[] = { 0x66, 0x8B, 0x1D, 0xC4, 0x7D, 0x62, 0x00, 0x66, 0x89, 0x5E, 0x46, 0x5B, 0x5E, 0x83, 0xC4, 0x14, 0xC3 };
		DDrPatch_Const ((char*)(OniExe + 0x0011a889), fadetime_patch);
		DDrPatch_Byte  ((char*)(OniExe + 0x0011a560), 0x31);
		
		// Sets the fadetime to 4800 by default
		DDrPatch_Int16 ((short*)(OniExe + 0x0011ab0e), 0x12c0);
	}
	
	// FIXME: add switches
	//pathfinding fix

	

	
	// Hackish fix for Konoko not kicking guns
	// Don't use this, it breaks stairs.
	if (patch_kickguns)
	{
		const unsigned char kickgun_patch[] = { 0x00, 0x05, 0x00, 0x00, 0x00, 0xC7, 0x05, 0x1C, 0xC9, 0x5E, 0x00, 0x70, 0xB8, 0x43, 0x00, 0xC7, 0x05, 0x20, 0xC9, 0x5E, 0x00, 0x20, 0xBE, 0x43 };
		DDrPatch_Const ((char*)(OniExe + 0x000dc420), kickgun_patch);
	}
	
	// Cooldown timer exploit fix ^_^
	if (patch_cooldowntimer)
	{
		const unsigned char cooldown_patch[] = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 };
		DDrPatch_Const ((char*)(OniExe + 0x0011a825), cooldown_patch);
	}
	
	if (patch_throwtest)
	{
		const unsigned char throwtest_patch[] = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 };
		DDrPatch_Const((char*)(OniExe + 0x000dc190), throwtest_patch);
	}
	
	// Disable UUrPlatform_Initalize/Terminate, this enables the Alt-Tab and the Windows key but has the possible side effect of allowing the screensaver to enable itself in-game.
	if (patch_alttab)
	{
		// 0xC3 = ret, so makes those functions just have a "ret" instruction at their start
		DDrPatch_Byte  ((char*)UUrPlatform_Initialize, 0xC3);
		DDrPatch_Byte  ((char*)UUrPlatform_Terminate, 0xC3);
	}
	
	// Unlocks particle action disabling/enabling bits for all events. (Will be controlled by a command line switch when I figure out how to do that without Win32 hacks.)
	if (patch_particledisablebit)
		DDrPatch_Int16 ((short*)(OniExe + 0x001b184), 0x9090);
	
	// Multi-byte patch (multiple language support)
	if (!patch_multibyte)
	{
		DDrPatch_Byte  ((char*)(OniExe + 0x0002d8f8), 0xeb);
		DDrPatch_Byte  ((char*)(OniExe + 0x0002d9ad), 0xeb);
		DDrPatch_Byte  ((char*)(OniExe + 0x0002dbe2), 0xeb);
		DDrPatch_Byte  ((char*)(OniExe + 0x0002dec3), 0xeb);
		DDrPatch_Byte  ((char*)(OniExe + 0x0002e2ab), 0xeb);
		DDrPatch_Byte  ((char*)(OniExe + 0x0002e2c4), 0xeb);
		DDrPatch_Byte  ((char*)(OniExe + 0x0002e379), 0xeb);
		DDrPatch_Byte  ((char*)(OniExe + 0x0002e48c), 0xeb);
		DDrPatch_Byte  ((char*)(OniExe + 0x0002e4d0), 0xeb);
		DDrPatch_Byte  ((char*)(OniExe + 0x0002e4f4), 0xeb);
		DDrPatch_Byte  ((char*)(OniExe + 0x0002e646), 0xeb);
		DDrPatch_Byte  ((char*)(OniExe + 0x0002e695), 0xeb);
		DDrPatch_Byte  ((char*)(OniExe + 0x0002e944), 0xeb);
		DDrPatch_Byte  ((char*)(OniExe + 0x0002e95d), 0xeb);
		DDrPatch_Byte  ((char*)(OniExe + 0x0002e98e), 0xeb);
		DDrPatch_Byte  ((char*)(OniExe + 0x0002e9dc), 0xeb);
	}
	
	// Cheat table patch
	if (patch_cheattable)
	{
		DDrPatch_Int32 ((int*)(OniExe + 0x000f616b), (int)&DDr_CheatTable[0].name);
		DDrPatch_Int32 ((int*)(OniExe + 0x000f617a), (int)&DDr_CheatTable[0].message_on);
	}
	
	// ARGB8888 textures
	if (patch_argb8888)
	{
		DDrPatch_Byte  ((char*)(OniExe + 0x00135af0), 0x07);
		DDrPatch_Byte  ((char*)(OniExe + 0x00135af4), 0x0B);
	}

	//Test newweap patch
	if (patch_newweapon) {
		
		//Makes it always say "Received weapon_name."
		//Needs check for loc_4DFC66
		//DDrPatch_NOOP((char*)(OniExe + 0x000E4DF8),2);

		//Adds Weapon name and ammo meter to pickup autoprompt
		DDrPatch_NOOP((char*)(OniExe + 0x000FAC73), 9);
		DDrPatch_NOOP((char*)(OniExe + 0x000FAC80), 5);
		DDrPatch_MakeCall((void*)(OniExe + 0xFAC85), (void*)DDrWeapon2Message);
		
		//Moves location of colors
		//DDrPatch_Int32((int*)(OniExe + 0x0002E3D5), (int)&DDrDSayColors );
		//DDrPatch_Int32((int*)(OniExe + 0x0002E3DA), (int)&DDrDSayColors );
	}
	
	// Disable loading the vtuneapi.dll
	//if (patch_killvtune)
		//DDrPatch_Byte  ((char*)(OniExe + 0x00026340), 0xC3);
	
	// Disable Oni's internal CLrGetCommandLine function (to eventually replace it with our own)
	if (patch_getcmdline)
		DDrPatch_NOOP  ((char*)(OniExe + 0x000d3280), 51);
	
	// Disable Oni's command line parser so it doesn't interfere with ours
	if (patch_disablecmdline)
		DDrPatch_Int32 ((int*)(OniExe + 0x000d3570), 0xc3c03366);
	
	if (patch_bsl)
	{
		//Calculating the value of the needed offset is much more reliable when the compiler does it for you.

		//TODO: fix moonshadow.
		Character * Chr = 0;
		int NoPath = (int)&(Chr[0].RegenHax) & 0x000000FF;
		const unsigned char regen_patch[] =
		{0x90, 0x90, 0x90, 0x90, 0x90,				// mov    al, _WPgRegenerationCheat	-> NOOP
		0x90, 0x90,									// test   al, al					-> NOOP
		0x90, 0x90,									// jz	  short loc_51BB98			-> NOOP
		0x8B, 0x86, (char)NoPath, 0x01, 0x00, 0x00, // mov     eax, [esi+Character.field_1E8]
													//	-> mov     eax, [esi+Character.RegenHax]
		0x85, 0xC0,									// test eax, eax
		0x74, 0x21									// jnz 0x21 -> jz 0x21
		};	
		DDrPatch_Const((char*)(OniExe + 0x0011BB64), regen_patch);
	}
	
	if(patch_chinese)
	{
		if (GetFileAttributes("xfhsm_oni.dll") != INVALID_FILE_ATTRIBUTES)
		{
			HMODULE dll;
			DWORD err;

	 		DDrStartupMessage("Daodan: Loading chinese DLL");
			dll = LoadLibrary("xfhsm_oni.dll");
			err = GetLastError();
			if( dll )
			{
				void* proc = GetProcAddress( dll, "InstallHook" );
				if(proc)
				{
					((CHINESEPROC)proc)(GetCurrentThreadId());
				}
			} else {
				char msg[100];
				FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, err, 0, msg, 100, NULL);
				DDrStartupMessage("Daodan: Loading DLL failed with error %i: %s", err, msg);
			}
		}
	}

	//Fix crappy ai2_shownames
	if(1)
	{
		//Set distance above head to 4.0
		DDrPatch_Int32((int*)(OniExe + 0x0008C998), 0x005296C8);
		//texture height
		DDrPatch_Byte((char*)(OniExe + 0x0008C9DF), 0x3F );
		//texture	width
		DDrPatch_NOOP((char*)(OniExe + 0x0008C9CA), 6 );
		//Set the text color to whatever we like ;)
		DDrPatch_NOOP((char*)(OniExe + 0x0008C898), 6 );
		DDrPatch_Byte((char*)(OniExe + 0x0008C898), 0x8B );
		DDrPatch_Byte((char*)(OniExe + 0x0008C899), 0xCE );
//FLATLINE?		DDrPatch_MakeCall((void*)(OniExe + 0x0008C8A3), FLrHook_DebugNameShadeHack);
		
		//Make the background black for additive blending
//FLATLINE?		DDrPatch_MakeCall((void*)(OniExe + 0x0008C802), FLrHook_DebugNameTextureInit );
	}

	if(1)
	{
		//DDrPatch_NOOP((char*)(OniExe + 0x000E1957), 6 );
		//DDrPatch_MakeCall((void*)(OniExe + 0x000E17F6), FLrHook_Lasers );
	}

	//Flatline related stuff
//	DDrPatch_MakeCall((void*)(OniExe + 0x000FBCEA), DDrText_Hook);
	
//FLATLINE?	DDrPatch_Int32((int*)(OniExe + 0x000B24D2), FLrSpawnHack);

//FLATLINE?	DDrPatch_NOOP((char*)(OniExe + 0x000C26CB), 6);

//FLATLINE?	DDrPatch_MakeCall((void*)(OniExe + 0x000C26CB), FLrHook_DoorOpen); 
//FLATLINE?	DDrPatch_MakeCall((void*)(OniExe + 0x000EE3CF), FLrHook_ConsoleActivate);


	// Fix options not visible in main menu when a game was started
	if(patch_optionsvisible)
	{
		DDrPatch_MakeCall((void*)(OniExe + 0x000d2d2d), DDrShowOptionsButton);
		DDrPatch_MakeCall((void*)(OniExe + 0x000d2d43), DDrShowResumeButton);
	}

	// Fix BinkBufferInit() call in BKrMovie_Play() to use GDI (DIB) blitting
	// instead of DirectDraw; patch ONiRunGame to use the same method to play
	// outro (ie., BKrMovie_Play() instead of ONrMovie_Play_Hardware() as the
	// latter has problems on WINE).
	if (patch_binkplay)
	{
		// push BINKBUFFERAUTO -> push BINKBUFFERDIBSECTION.
		DDrPatch_Byte((void*)(OniExe + 0x0008829b + 1), 0x02);
		// call ONrMovie_Play_Hardware -> call ONrMovie_Play
		DDrPatch_MakeCall((void*)(OniExe + 0x000d496f), ONrMovie_Play);
	}

	// Patch a gamma slider in Options dialog (unconditionally).
	// ONiOGU_Options_InitDialog: replace WMrSlider_SetRange(gammaSliderWindow, ...)
	// call with our hook function.
	DDrPatch_MakeCall((void*)(OniExe + 0x000d262c), (void*)DD_ONiOGU_GammaSlider_SetRange);

	// Safe startup message printer
	if (patch_safeprintf)
		DDrPatch_MakeJump((void*)UUrStartupMessage, (void*)DDrStartupMessage);
	
	// Daodan device mode enumeration function
	if (patch_daodandisplayenum)
		DDrPatch_MakeJump((void*)gl_enumerate_valid_display_modes, (void*)DD_GLrEnumerateDisplayModes);
	
	// Performance patch
	if (patch_usegettickcount)
	{
		DDrPatch_MakeJump((void*)UUrMachineTime_High, (void*)DDrMachineTime_High);
		DDrPatch_MakeJump((void*)UUrMachineTime_High_Frequency, (void*)DDrMachineTime_High_Frequency);
		DDrPatch_MakeJump((void*)UUrMachineTime_Sixtieths, (void*)DDrMachineTime_Sixtieths);
	}

	// Cheats always enabled
	if (patch_cheatsenabled)
		DDrPatch_MakeJump((void*)ONrPersist_GetWonGame, (void*)DDrPersist_GetWonGame);

	// DaodanGL with windowed mode support.
	if (patch_usedaodangl)
	{
		// LIrPlatform_Mode_Set: GetWindowRect -> GetClientRect.
		DDrPatch_NOOP((char*) OniExe + 0x00002dd6, 6);
		DDrPatch_MakeCall((char*) OniExe + 0x00002dd6, (void*) GetClientRect);

		// UUrWindow_GetSize: GetWindowRect -> GetClientRect.
		DDrPatch_NOOP((char*) OniExe + 0x0002651c, 6);
		DDrPatch_MakeCall((char*) OniExe + 0x0002651c, (void*) GetClientRect);

		// LIrPlatform_PollInputForAction: fix GetCursorPos call to return client coordinates.
		DDrPatch_NOOP((char*) OniExe + 0x000032cc, 6);
		DDrPatch_MakeCall((char*) OniExe + 0x000032cc, (void*) DD_GetCursorPos);

		// LIrPlatform_InputEvent_GetMouse: fix GetCursorPos call to return client coordinates.
		DDrPatch_NOOP((char*) OniExe + 0x00002cc2, 6);
		DDrPatch_MakeCall((char*) OniExe + 0x00002cc2, (void*) DD_GetCursorPos);

		// LIrPlatform_PollInputForAction: translate SetCursorPos position to screen coordinates.
		DDrPatch_NOOP((char*) OniExe + 0x000032b7, 6);
		DDrPatch_MakeCall((char*) OniExe + 0x000032b7, (void*) DD_SetCursorPos);

		// LIrPlatform_PollInputForAction: translate SetCursorPos position to screen coordinates.
		DDrPatch_NOOP((char*) OniExe + 0x00003349, 6);
		DDrPatch_MakeCall((char*) OniExe + 0x00003349, (void*) DD_SetCursorPos);

		// Replace ONrPlatformInitialize.
		DDrPatch_MakeJump((void*) ONrPlatform_Initialize, (void*) DD_ONrPlatform_Initialize);

		// Replace gl_platform_initialize.
		DDrPatch_MakeJump((void*) gl_platform_initialize, (void*) DD_GLrPlatform_Initialize);

		// Replace gl_platform_dispose.
		DDrPatch_MakeJump((void *) gl_platform_dispose, (void*) DD_GLrPlatform_Dispose);
 	}

	if (patch_clipcursor)
	{
		// LIrMode_Set: replace LIrPlatform_Mode_Set call with our hook.
		DDrPatch_MakeCall((void*)(OniExe + 0x00003f9f), (void*) DD_LIrPlatform_Mode_Set);

		// LIrMode_Set_Internal: replace LIrPlatform_Mode_Set call with our hook.
		DDrPatch_MakeCall((void*)(OniExe + 0x00003fff), (void*) DD_LIrPlatform_Mode_Set);
		
		// LIrTermiante: replace LIrPlatform_Terminate call with our hook.
		DDrPatch_MakeCall((void*)(OniExe + 0x000004cb8), (void*) DD_LIrPlatform_Terminate);
	}

	
	if (patch_daodaninit)
		DDrPatch_MakeCall((void*)(OniExe + 0x000d345a), (void*)DDrGame_Init);
	
	// Patches for existing BSL functions
	if (patch_bsl)
		SLrDaodan_Patch();
		
	if (patch_cheater)
	{
		DDrPatch_MakeCall((void*)(OniExe + 0x000f618f), (void*)DDrCheater);
		DDrPatch_Int16((short*)(OniExe + 0x000deb45), 0x5590);
#if 1
		DDrPatch_MakeCall((void*)(OniExe + 0x000deb47), (void*)FallingFrames);
#endif
		DDrPatch_MakeJump((void*)(OniExe + 0x0010f021), (void*)DDrCheater_LevelLoad);
	}

	DDrPatch_MakeJump((void*)(OniExe + 0x000245A0), (void*)DDrPrintWarning);


	return true;
}


void DDrException() {
	int* i = 0;
	*i = 1;
}

void __cdecl DDrMain(int argc, char* argv[])
{
	DDrStartupMessage("Daodan: Daodan attached!");
	
	// Tell Oni to not load non levelX_final-files by default:
	opt_ignore_private_data = false;

	// Enable sound by default:
	opt_sound = true;
	
	DDrConfig(argc, argv);

	DDrPatch_Init();
	
	
	ONiMain(argc, argv);
}
/*
void DDrWrongExe()
{
	switch (MessageBox(NULL, "This version of the Daodan DLL is incompatible with your Oni.exe.\n"
		"Click OK for more information. To continue using Oni without the patch, replace the downloaded binkw32.dll with the original.", "Daodan", MB_OKCANCEL | MB_ICONERROR))
	{
		case IDOK:
			{
				STARTUPINFO si;
				PROCESS_INFORMATION pi;
				FillMemory(&si, 0, sizeof(si));
				FillMemory(&pi, 0, sizeof(pi));
				si.cb = sizeof(si);
				if (!CreateProcess(NULL, "cmd /c \"start http://wiki.oni2.net/Daodan_DLL\"", NULL, NULL, FALSE, 0, NULL, NULL, &si, &pi))
					MessageBox(NULL, "", "", 0);
				CloseHandle(pi.hProcess);
				CloseHandle(pi.hThread);
			}
		default:
			ExitProcess(0);
	}
}
*/
BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpReserved)
{
	switch (fdwReason)
	{
		case DLL_PROCESS_ATTACH:
			DDrDLLModule = hinstDLL;
			DDrONiModule = GetModuleHandle(NULL);
			
			if (*(uint32_t*)(OniExe + 0x0011acd0) == 0x09d36852)
				DDrPatch_MakeCall((void*)(OniExe + 0x0010fb49), (void*)DDrMain);
			else
				ExitProcess(0);
			break;
	}
	return TRUE;
}
