#ifndef FLATLINE_PACKET_H
#define FLATLINE_PACKET_H
#include "stdint.h"


uint16_t FLpData_PartSize( uint8_t e);
void FLsSendPlayerData();
//void FLcReadPlayerData( flatline_packet* Packet, int16_t Size );

typedef struct
{
	uint16_t ID;
	uint16_t Size;
	uint16_t UpdateFlags;
	uint8_t  data[255];
} PlayerData;


typedef struct {
	uint32_t Actions1;
	uint32_t Actions2;
	float MouseDeltaX;
	float MouseDeltaY;	
} PlayerInput;

typedef struct {
	float Facing;
	float DesiredFacing;
} PlayerFacing;

typedef struct {
	uint16_t Health;
	uint16_t MaxHealth;
} PlayerHealth;

typedef struct {
	uint16_t Score;
	uint16_t Deaths;
} PlayerScore;

//Change this later to be misc info
typedef struct {
	uint16_t Frame;
	uint16_t Ping;
} PlayerFP;

typedef struct {
	uint8_t Ammo;
	uint8_t Cells;
	uint8_t Hypo;
	uint8_t pad;
	uint16_t Invis;
	uint16_t Shield;
} PlayerInventory;

typedef struct {
	uint16_t				throwing;
	uint16_t				throwFrame;
	char					throwName[32];
} PlayerThrowData;

enum
{
	PFlag_None,
	PFlag_Input,
	PFlag_Facing,	
	PFlag_Health,		
	PFlag_Score,		//TODO
	PFlag_FramePing,
	PFlag_Inventory, //TODO
	PFlag_Class,	
	PFlag_Position,
	PFlag_Animation,	
	PFlag_Throws,
	PFlag_Max,
	PFlag_AnimationWait,//Clients only!
};



#endif