#include "Flatline.h"
#include "Flatline_Packet.h"

bool DoWeUpdateThis( uint16_t BitSet, uint16_t Flag )
{
	if( BitSet & (1 << Flag) ) return true;
	return false;
}

//Long winded?



void FLcPacketBufferToPlayerData( PlayerData* PD)
{
	player_info* PI = PlayerList[PD->ID];
	uint8_t * DataPointer = PD->data;

	static player_info BufferData[MAX_PLAYERS] = {0};
	static bool IsBuffered[32];
	

	if(!PI)
	{
		//TODO: Store this data and then apply it once we have a character that matches!
		flatline_packet pk;
		pk.id = PK_MISSING_PLAYER;
		pk.integer = PD->ID;
		DDrConsole_Print("input");
		NetUDPSocket_Send(client_sock, (sockaddr*)&address, (char*)&pk, FLATLINE_HEADER + 4 );
		
		IsBuffered[PD->ID] = 1;
		PI = &BufferData[PD->ID];
		
		//return;
	}
	else if(IsBuffered[PD->ID])
	{
		player_info* Buffer = BufferData + PD->ID;
		if( DoWeUpdateThis( Buffer->UpdateFlags, PFlag_Input) )	PI->Input = Buffer->Input;
		if( DoWeUpdateThis( Buffer->UpdateFlags, PFlag_Facing) )	PI->Facings = Buffer->Facings;
		if( DoWeUpdateThis( Buffer->UpdateFlags, PFlag_Health) )	PI->Health = Buffer->Health;
		if( DoWeUpdateThis( Buffer->UpdateFlags, PFlag_FramePing) )	{
			PI->Frame = Buffer->Frame;
			PI->Ping = Buffer->Ping;
		}
		//if( DoWeUpdateThis( Buffer->UpdateFlags, PFlag_Inventory) )	PI->invi= Buffer->Input;
		if( DoWeUpdateThis( Buffer->UpdateFlags, PFlag_Class) )	
		{
			PI->Class = Buffer->Class;
			/*THIS MIGHT BE BAD*/ snprintf( PI->ClassString, 32, "%s", Buffer->ClassString );
		}

		if( DoWeUpdateThis( Buffer->UpdateFlags, PFlag_Position) )	PI->Position = Buffer->Position;
		if( DoWeUpdateThis( Buffer->UpdateFlags, PFlag_Animation) )	
		{
			PI->Animation = Buffer->Animation;
			/*THIS MIGHT BE BAD*/ snprintf( PI->AnimationString, 32, "%s", Buffer->AnimationString);
		}
		if( DoWeUpdateThis( Buffer->UpdateFlags, PFlag_Throws) )	PI->ThrowData = Buffer->ThrowData;
		
		PI->UpdateFlags |= Buffer->UpdateFlags;
		IsBuffered[PD->ID] = 0;
	}

	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_Input) )
	{
		PI->Input = *(PlayerInput*)DataPointer;
		DataPointer += FLpData_PartSize( PFlag_Input);
	}

	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_Facing) )
	{
		PI->Facings = *(PlayerFacing*)DataPointer;
		DataPointer += FLpData_PartSize( PFlag_Facing);
	}

	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_Health) )
	{
		PI->Health = *(PlayerHealth*)DataPointer;
		DataPointer += FLpData_PartSize( PFlag_Health);
	}

	//Not done
	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_Score) )
	{
		PI->Score = *(PlayerScore*)DataPointer;
		DataPointer += FLpData_PartSize( PFlag_Score);
	}
	
	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_FramePing) )
	{
		PlayerFP* FP = (PlayerFP*)DataPointer;
		PI->Ping = FP->Ping;
		
		if(FP->Frame != -1)
		{
			PI->Frame = FP->Frame;
		}
		else
		{
			PD->UpdateFlags &= ~( 1 << PFlag_FramePing );
		}
		DataPointer += FLpData_PartSize( PFlag_FramePing);
	}
	
	//Not done
	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_Inventory) )
	{
		PI->Inventory = *(PlayerInventory*)DataPointer;
		DataPointer += FLpData_PartSize( PFlag_Inventory );
	}
		
	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_Class ) )
	{
		/*THIS MIGHT BE BAD*/ snprintf( PI->ClassString, 32, "%s", DataPointer );
		TMrInstance_GetDataPtr( 'ONCC', (char*)DataPointer, &PI->Class ); 
		DataPointer += FLpData_PartSize( PFlag_Class );
	}
		
	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_Position ) )
	{
		PI->Position = *(Vector3*)DataPointer;
		DataPointer += FLpData_PartSize( PFlag_Position );
	}
		
	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_Animation ) )
	{
		/*THIS MIGHT BE BAD*/ snprintf( PI->AnimationString, 32, "%s", DataPointer );
		TMrInstance_GetDataPtr( 'TRAM', PI->AnimationString, &PI->Animation );
		DataPointer += FLpData_PartSize( PFlag_Animation );
	}
		
	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_Throws ) )
	{
		PI->ThrowData = *(PlayerThrowData*)DataPointer;
		DataPointer += FLpData_PartSize( PFlag_Throws );
	}


	PI->UpdateFlags |= PD->UpdateFlags;
}

void FLcReadPlayerData( flatline_packet* Packet, int16_t Size )
{
	PlayerData* PDCast = (PlayerData*)Packet->data;
	Size -= FLATLINE_HEADER;
	while(Size > 0)
	{
		if(PDCast->Size > Size)
		{
			DDrConsole_PrintF( "Warning, (almost) read %hi bytes too much of player data buffer", -Size );
			break;
		}
		FLcPacketBufferToPlayerData( PDCast );
		Size -= PDCast->Size;
		PDCast = (PlayerData*)((char*)PDCast + PDCast->Size);
	}

	//Packet
}
