#include <windows.h>
#include <string.h>

#include "Daodan_Cheater.h"
#include "Daodan_Config.h"
#include "Daodan_Patch.h"
#include "Daodan_Utility.h"

#include "Oni_Symbols.h"

#include "Inifile_Reader.h"

bool patch_alttab = true;
bool patch_argb8888 = true;
bool patch_binkplay = true;
bool patch_bsl = true;
bool patch_cheater = true;
bool patch_cheatsenabled = true;
bool patch_cheattable = true;
bool patch_clipcursor = true;
bool patch_cooldowntimer = true;
bool patch_daodandisplayenum = true;
bool patch_directinput = true;
bool patch_disablecmdline = true;
bool patch_flatline = true;
bool patch_fonttexturecache = true;
bool patch_getcmdline = true;
bool patch_hdscreens_lowres = true;
bool patch_highres_console = true;
bool patch_kickguns = false;
bool patch_killvtune = true;
bool patch_largetextures = true;
bool patch_levelplugins = true;
bool patch_newweapon = true;
bool patch_nomultibyte = true;
bool patch_optionsvisible = true;
bool patch_particledisablebit = false;
bool patch_pathfinding = true;
bool patch_projaware = true;
bool patch_safeprintf = true;
bool patch_showalllasersights = false;
bool patch_showtriggervolumes = true;
bool patch_throwtest = false;
bool patch_usedaodangl = true;
bool patch_usegettickcount = true;
bool patch_wpfadetime = true;

bool opt_border = true;
bool opt_gamma = true;
bool opt_topmost = false;
bool opt_usedaodanbsl = true;

bool patch_chinese = true;


enum {s_unknown, s_options, s_patch, s_bsl, s_language} ini_section;

bool DDrIniCallback(char* section, bool newsection, char* name, char* value)
{
	if (newsection)
	{
		if (!_stricmp(section, "options"))
			ini_section = s_options;
		else if (!_stricmp(section, "patch") || !_stricmp(section, "patches"))
			ini_section = s_patch;
		else if (!_stricmp(section, "bsl"))
			ini_section = s_bsl;
		else if (!_stricmp(section, "language"))
			ini_section = s_language;
		else
		{
			ini_section = s_unknown;
			DDrStartupMessage("Daodan: Unrecognised ini section \"%s\"", section);
		}
	}
	
	switch (ini_section)
	{
		case s_options:
			if (!_stricmp(name, "border"))
				opt_border = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "debug"))
				AKgDebug_DebugMaps = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "debugfiles"))
				BFgDebugFileEnable = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "findsounds"))
				SSgSearchOnDisk = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "gamma"))
				opt_gamma = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "ignore_private_data"))
				opt_ignore_private_data = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "nomultibyte"))
				patch_nomultibyte = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "sound"))
				opt_sound = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "switch"))
				M3gResolutionSwitch = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "topmost"))
				opt_topmost = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "usedaodanbsl"))
				opt_usedaodanbsl = !_stricmp(inifile_cleanstr(value), "true");
			else
				DDrStartupMessage("Daodan: Unrecognised ini option \"%s\"", name);
			break;
		case s_patch:
			if (!_stricmp(name, "alttab"))
				patch_alttab = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "argb8888"))
				patch_argb8888 = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "binkplay"))
				patch_binkplay = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "bsl"))
				patch_bsl = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "cheater"))
				patch_cheater = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "cheatsenabled"))
				patch_cheatsenabled = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "cheattable"))
				patch_cheattable = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "clipcursor"))
				patch_clipcursor = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "cooldowntimer"))
				patch_cooldowntimer = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "daodandisplayenum"))
				patch_daodandisplayenum = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "directinput"))
				patch_directinput = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "disablecmdline"))
				patch_disablecmdline = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "flatline"))
				patch_flatline = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "fonttexturecache"))
				patch_fonttexturecache = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "getcmdline"))
				patch_getcmdline = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "hdscreens_lowres"))
				patch_hdscreens_lowres = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "highres_console"))
				patch_highres_console = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "kickguns"))
				patch_kickguns = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "killvtune"))
				patch_killvtune = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "largetextures"))
				patch_largetextures = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "levelplugins"))
				patch_levelplugins = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "nomultibyte"))
				patch_nomultibyte = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "newweap"))
				patch_newweapon = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "optionsvisible"))
				patch_optionsvisible = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "particledisablebit"))
				patch_particledisablebit = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "pathfinding"))
				patch_pathfinding = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "projaware"))
				patch_projaware = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "safeprintf"))
				patch_safeprintf = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "showalllasersights"))
				patch_showalllasersights = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "showtriggervolumes"))
				patch_showtriggervolumes = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "throwtest"))
				patch_throwtest = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "usedaodangl"))
				patch_usedaodangl = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "usegettickcount"))
				patch_usegettickcount = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "wpfadetime"))
				patch_wpfadetime = !_stricmp(inifile_cleanstr(value), "true");
			else
				DDrStartupMessage("Daodan: Unrecognised ini patch \"%s\"", name);
			break;
		case s_language:
			if (!_stricmp(name, "chinese"))
				patch_chinese = !_stricmp(inifile_cleanstr(value), "true");
			else if (!_stricmp(name, "blam"))
				DDrPatch__strdup((int*)(OniExe + 0x0010fb73), value);
			else if (!_stricmp(name, "damn"))
				DDrPatch__strdup((int*)(OniExe + 0x0010fb6e), value);
			else if (!_stricmp(name, "savepoint"))
			{
				char* str = _strdup(value);
				DDrPatch_Int32((int*)(OniExe + 0x000fd730), (int)str);
				DDrPatch_Int32((int*)(OniExe + 0x000fd738), (int)str);
			}
			else if (!_stricmp(name, "syndicatewarehouse"))
			{
				char* str = _strdup(value);
				DDrPatch_Int32((int*)(OniExe + 0x000fd71a), (int)str);
				DDrPatch_Int32((int*)(OniExe + 0x0010ef75), (int)str);
			}
			else if (!_stricmp(name, "shapeshifter_on"))
				DDr_CheatTable[0].message_on = _strdup(value);
			else if (!_stricmp(name, "shapeshifter_off"))
				DDr_CheatTable[0].message_off = _strdup(value);
			else if (!_stricmp(name, "liveforever_on"))
				DDr_CheatTable[1].message_on = _strdup(value);
			else if (!_stricmp(name, "liveforever_off"))
				DDr_CheatTable[1].message_off = _strdup(value);
			else if (!_stricmp(name, "touchofdeath_on"))
				DDr_CheatTable[2].message_on = _strdup(value);
			else if (!_stricmp(name, "touchofdeath_off"))
				DDr_CheatTable[2].message_off = _strdup(value);
			else if (!_stricmp(name, "canttouchthis_on"))
				DDr_CheatTable[3].message_on = _strdup(value);
			else if (!_stricmp(name, "canttouchthis_off"))
				DDr_CheatTable[3].message_off = _strdup(value);
			else if (!_stricmp(name, "fatloot_on"))
				DDr_CheatTable[4].message_on = _strdup(value);
			else if (!_stricmp(name, "glassworld_on"))
				DDr_CheatTable[5].message_on = _strdup(value);
			else if (!_stricmp(name, "glassworld_off"))
				DDr_CheatTable[5].message_off = _strdup(value);
			else if (!_stricmp(name, "winlevel_on"))
				DDr_CheatTable[6].message_on = _strdup(value);
			else if (!_stricmp(name, "loselevel_on"))
				DDr_CheatTable[7].message_on = _strdup(value);
			else if (!_stricmp(name, "bighead_on"))
				DDr_CheatTable[8].message_on = _strdup(value);
			else if (!_stricmp(name, "bighead_off"))
				DDr_CheatTable[8].message_off = _strdup(value);
			else if (!_stricmp(name, "minime_on"))
				DDr_CheatTable[9].message_on = _strdup(value);
			else if (!_stricmp(name, "minime_off"))
				DDr_CheatTable[9].message_off = _strdup(value);
			else if (!_stricmp(name, "superammo_on"))
				DDr_CheatTable[10].message_on = _strdup(value);
			else if (!_stricmp(name, "superammo_off"))
				DDr_CheatTable[10].message_off = _strdup(value);
			else if (!_stricmp(name, "devmode_on"))
			{
				char* str = _strdup(value);
				DDr_CheatTable[11].message_on = str;
				DDr_CheatTable[cheat_x].message_on = str;
			}
			else if (!_stricmp(name, "devmode_off"))
			{
				char* str = _strdup(value);
				DDr_CheatTable[11].message_off = str;
				DDr_CheatTable[cheat_x].message_off = str;
			}
			else if (!_stricmp(name, "reservoirdogs_on"))
				DDr_CheatTable[12].message_on = _strdup(value);
			else if (!_stricmp(name, "reservoirdogs_off"))
				DDr_CheatTable[12].message_off = _strdup(value);
			else if (!_stricmp(name, "roughjustice_on"))
				DDr_CheatTable[13].message_on = _strdup(value);
			else if (!_stricmp(name, "roughjustice_off"))
				DDr_CheatTable[13].message_off = _strdup(value);
			else if (!_stricmp(name, "chenille_on"))
				DDr_CheatTable[14].message_on = _strdup(value);
			else if (!_stricmp(name, "chenille_off"))
				DDr_CheatTable[14].message_off = _strdup(value);
			else if (!_stricmp(name, "behemoth_on"))
				DDr_CheatTable[15].message_on = _strdup(value);
			else if (!_stricmp(name, "behemoth_off"))
				DDr_CheatTable[15].message_off = _strdup(value);
			else if (!_stricmp(name, "elderrune_on"))
				DDr_CheatTable[16].message_on = _strdup(value);
			else if (!_stricmp(name, "elderrune_off"))
				DDr_CheatTable[16].message_off = _strdup(value);
			else if (!_stricmp(name, "moonshadow_on"))
				DDr_CheatTable[17].message_on = _strdup(value);
			else if (!_stricmp(name, "moonshadow_off"))
				DDr_CheatTable[17].message_off = _strdup(value);
			else if (!_stricmp(name, "munitionfrenzy_on"))
				DDr_CheatTable[18].message_on = _strdup(value);
			else if (!_stricmp(name, "fistsoflegend_on"))
				DDr_CheatTable[19].message_on = _strdup(value);
			else if (!_stricmp(name, "fistsoflegend_off"))
				DDr_CheatTable[19].message_off = _strdup(value);
			else if (!_stricmp(name, "killmequick_on"))
				DDr_CheatTable[20].message_on = _strdup(value);
			else if (!_stricmp(name, "killmequick_off"))
				DDr_CheatTable[20].message_off = _strdup(value);
			else if (!_stricmp(name, "carousel_on"))
				DDr_CheatTable[21].message_on = _strdup(value);
			else if (!_stricmp(name, "carousel_off"))
				DDr_CheatTable[21].message_off = _strdup(value);
			else
				DDrStartupMessage("Daodan: Unrecognised ini language item \"%s\"", name);
			break;
		case s_bsl:
		default:
			break;
	}
	
	return true;
}

void DDrConfig(int argc, char* argv[])
{
	int i;
	char* section;
	char* option;
	bool falseoption;


	// Tell Oni to not load non levelX_final-files by default:
	opt_ignore_private_data = false;

	// Enable sound by default:
	opt_sound = true;


	if (GetFileAttributes("daodan.ini") == INVALID_FILE_ATTRIBUTES)
	{
		FILE* fp;
		DDrStartupMessage("Daodan: daodan.ini doesn't exist, creating");
		fp = fopen("daodan.ini", "w");
		if (fp)
		{
			fputs("[Options]\n", fp);
			fputs("[Patch]\n", fp);
			fputs("[BSL]\n", fp);
			fputs("[Language]\n", fp);
			fclose(fp);
		}
	}
	
	DDrStartupMessage("Daodan: Parsing daodan.ini...");
	if (!inifile_read("daodan.ini", DDrIniCallback))
		DDrStartupMessage("Daodan: Error reading daodan.ini, check your syntax!");
	DDrStartupMessage("Daodan: Finished parsing");



	DDrStartupMessage("Daodan: Parsing command line...");
	for (i = 1; i < argc; i ++)
	{
		if (argv[i][0] == '-')
		{
			section = argv[i] + 1;
			if ((option = strchr(argv[i], '.')))
			{
				*option = '\0';
				falseoption = (option[1] == 'n' || option[1] == 'N') && (option[2] == 'o' || option[2] == 'O');
				if (i < (argc - 1) && argv[i + 1][0] != '-')
					DDrIniCallback(section, true, option + 1, argv[++i]);
				else
					DDrIniCallback(section, true, option + (falseoption ? 3 : 1), (falseoption ? "false" : "true"));
				*option = '.';
			}
			else
			{
				falseoption = (section[0] == 'n' || section[0] == 'N') && (section[1] == 'o' || section[1] == 'O');
				ini_section = s_options;
				if (i < (argc - 1) && argv[i + 1][0] != '-')
					DDrIniCallback(NULL, false, section, argv[++i]);
				else
					DDrIniCallback(NULL, false, section + (falseoption ? 2 : 0), (falseoption ? "false" : "true"));
			}
		}
		else
		{
			DDrStartupMessage("Daodan: Parse error \"%s\"", argv[i]);
			break;
		}
	}
	DDrStartupMessage("Daodan: Finished parsing");
}

