#include "mailFromGui.h"

#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>


#define WIN_WIDTH  450
#define WIN_HEIGHT 270

enum {
	TXT_INFO,
	TXT_MAIL,
	EDIT_MAIL,
	CHK_CC,
	BTN_SEND,
	BTN_ABORT
} window_objects;

bool isSendSelected = false;
bool isCCSelected = false;
char* emailFrom = 0;

static HWND hwndEditMail;

static bool verifyMail() {
	char* at = strchr(emailFrom, '@');
	char* dot = strrchr(emailFrom, '.');
	if (at == NULL || dot == NULL)
		return false;
	if (dot <= at)
		return false;

	unsigned int atPos = at - emailFrom;
	unsigned int dotPos = dot - emailFrom;
	if (atPos < 1 || (dotPos - atPos) < 2)
		return false;
	if (dotPos >= strlen(emailFrom)-1)
		return false;

	return true;
}

static void handleWindowCreate(HWND hwnd) {
	static LPCSTR txtInfo = "\
With this program you can request help from the AE\n\
support team if you have trouble installing the AE.\n\
\n\
Please only use this if you are asked to on the forum!\n\
\n\
The information that is sent is:\n\
- AEI updater's updater_output.log\n\
- AEI-ProxySettings.xml\n\
- A list of files within your AE/ folder";

	int top = 0, left = 5;
	int height, width = WIN_WIDTH - 2*left - 4;

	top += 5;
	height = 150;
	CreateWindowA("STATIC", txtInfo, 
		WS_CHILD | WS_VISIBLE | SS_LEFT,
		left, top, width, height,
		hwnd, (HMENU) TXT_INFO, NULL, NULL);

	top += height + 5;
	height = 20;
	width = 145;
	CreateWindowA("STATIC", "Your e-mail address:", 
		WS_CHILD | WS_VISIBLE | SS_LEFT,
		left, top, width, height,
		hwnd, (HMENU) TXT_MAIL, NULL, NULL);
	left += width + 5;
	width = WIN_WIDTH - 20 - width;
	hwndEditMail = CreateWindowA("Edit", NULL, 
		WS_CHILD | WS_VISIBLE | WS_BORDER,
		left, top, width, height, hwnd, (HMENU) EDIT_MAIL,
		NULL, NULL);
	left = 5;
	width = WIN_WIDTH - 2*left - 4;

	top += height + 5;
	height = 20;
	CreateWindowA("button", "Send a copy of the mail to you",
		WS_VISIBLE | WS_CHILD | BS_CHECKBOX,
		left, top, width, height, hwnd, (HMENU) CHK_CC, 
		NULL, NULL);

	top += height + 5;
	height = 28;
	width = 100;
	left = WIN_WIDTH - 3*5 - 2*width;
	CreateWindowA("button", "Send request",
		WS_VISIBLE | WS_CHILD ,
		left, top, width, height,
		hwnd, (HMENU) BTN_SEND, NULL, NULL);
	left = WIN_WIDTH - 2*5 - 1*width;
	CreateWindowA("button", "Abort",
		WS_VISIBLE | WS_CHILD ,
		left, top, width, height,
		hwnd, (HMENU) BTN_ABORT, NULL, NULL);
}

static void handleWindowCommand(HWND hwnd, WPARAM wParam) {
	bool checked;
	int len;
	
	switch (LOWORD(wParam)) {
		case BTN_SEND:
			len = GetWindowTextLengthA(hwndEditMail) + 1;
			emailFrom = malloc(len);
			GetWindowTextA(hwndEditMail, emailFrom, len);

			if (verifyMail()) {
				isSendSelected = true;
				ShowWindow(hwnd, SW_HIDE);
				PostQuitMessage(0);
			} else {
				MessageBox(hwnd, "Please enter a valid e-mail address", "Invalid e-mail", MB_OK | MB_ICONEXCLAMATION);
			}
			break;
		case BTN_ABORT:
			PostQuitMessage(0);
			break;
		case CHK_CC:
			checked = IsDlgButtonChecked(hwnd, CHK_CC);
			if (checked) {
				CheckDlgButton(hwnd, CHK_CC, BST_UNCHECKED);
				isCCSelected = false;
			} else {
				CheckDlgButton(hwnd, CHK_CC, BST_CHECKED);
				isCCSelected = true;
			}
			break;
	}
}

static LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
		case WM_CREATE:
			handleWindowCreate(hwnd);
			break;

		case WM_COMMAND:
			handleWindowCommand(hwnd, wParam);
			break;

		case WM_DESTROY:
			PostQuitMessage(0);
			return 0;      
	}

	return DefWindowProcW(hwnd, msg, wParam, lParam);
}


void mailFromGui(HMODULE hInstance, int nCmdShow)
{
	static const LPCWSTR title = L"Request Help";

	MSG  msg;    
	HWND hwnd;
	WNDCLASSW wc;

	wc.style         = CS_HREDRAW | CS_VREDRAW;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.lpszClassName = L"Window";
	wc.hInstance     = hInstance;
	wc.hbrBackground = GetSysColorBrush(COLOR_3DFACE);
	wc.lpszMenuName  = NULL;
	wc.lpfnWndProc   = WndProc;
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
	wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);

	RegisterClassW(&wc);
	hwnd = CreateWindowW( wc.lpszClassName, title,
		WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_VISIBLE,
		CW_USEDEFAULT, CW_USEDEFAULT, WIN_WIDTH, WIN_HEIGHT, NULL, NULL, hInstance, NULL);  

	ShowWindow(hwnd, nCmdShow);
	UpdateWindow(hwnd);

	while( GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
}

