unit TypeDefs;
interface

uses
  Graphics, SysUtils;

type
  ENotImplemented = class(Exception);

  TDataBackend = (DB_ONI, DB_ADB);
  TDataOS = (DOS_WIN, DOS_WINDEMO, DOS_MAC, DOS_MACBETA);

  TChangeRights = set of (CR_EditDat, CR_EditRaw, CR_ResizeDat, CR_ResizeRaw, CR_AppendRaw);

  TStatusMessages = (
      SM_OK,
      SM_AlreadyOpened,
      SM_FileNotFound,
      SM_UnknownExtension,
      SM_IncompatibleFile,
      SM_IncompatibleDBVersion,
      SM_UnknownError
  ); 

  TExtensionsMap = array of packed record
      Ident:       array[0..$7] of Byte;
      Extension:   array[0..$3] of Char;
      ExtCount:    LongWord;
  end;

  TFileInfo = packed record
      ID:          Integer;
      Name:        String;
      Extension:   String[4];
      Size:        Integer;
      FileType:    LongWord;
      DatAddr:     Integer;
  end;
  TFiles = array of TFileInfo;

  TRawDataInfo = record
      SrcID:       Integer;
      SrcOffset:   Integer;
      RawAddr:     Integer;
      RawSize:     Integer;
      LocSep:      Boolean;
  end;
  TRawDataList = array of TRawDataInfo;

  TSortType = (
      ST_IDAsc,
      ST_IDDesc,
      ST_NameAsc,
      ST_NameDesc,
      ST_ExtAsc,
      ST_ExtDesc
  );

  TExtensionFormat = (
      EF_ExtOnly,
      EF_ExtCount
  );

  TByteData = array of Byte; 

  TAppSettings = record
      DatPath:        String[250];
      ExtractPath:    String[250];
      FilenumbersAsHex: Boolean;
      CharSet:        TFontCharSet;
      HideUnusedData: Boolean;
  end;

  TToolList = array of record
    context: String;
    name: String;
    exts: String;
  end;

{
  TLevelInfo = record
    Ident: array[0..$13] of Byte;
    LevelNumber: Byte;
  end;

 TDatLinks = array of record
    Src_Offset: LongWord;
    Target:     LongWord;
  end;
}

const
  CrLf: String[2] = #13#10;

implementation

end.
