/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea15;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAdminArea16
extends SVNAdminArea15 {
    public static final int WC_FORMAT = 10;

    public SVNAdminArea16(File dir) {
        super(dir);
    }

    public boolean hasTreeConflict(String victimName) throws SVNException {
        return this.getTreeConflict(victimName) != null;
    }

    public SVNTreeConflictDescription getTreeConflict(String victimName) throws SVNException {
        SVNEntry dirEntry = this.getEntry(this.getThisDirName(), false);
        if (dirEntry == null) {
            return null;
        }
        Map<File, SVNTreeConflictDescription> conflicts = dirEntry.getTreeConflicts();
        return conflicts.get(this.getFile(victimName));
    }

    public void addTreeConflict(SVNTreeConflictDescription conflict) throws SVNException {
        SVNTreeConflictDescription existingDescription = this.getTreeConflict(conflict.getPath().getName());
        if (existingDescription != null) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Attempt to add tree conflict that already exists at ''{0}''", (Object)conflict.getPath());
            SVNErrorManager.error(error, SVNLogType.WC);
        }
        SVNHashMap conflicts = new SVNHashMap();
        conflicts.put(conflict.getPath(), conflict);
        String conflictData = SVNTreeConflictUtil.getTreeConflictData(conflicts);
        SVNProperties command = new SVNProperties();
        command.put("name", this.getThisDirName());
        command.put("data", conflictData);
        SVNLog log = this.getLog();
        log.addCommand("add-tree-conflict", command, false);
        log.save();
        this.runLogs();
    }

    public SVNTreeConflictDescription deleteTreeConflict(String victimName) throws SVNException {
        File victimPath;
        SVNEntry dirEntry = this.getEntry(this.getThisDirName(), false);
        Map<File, SVNTreeConflictDescription> conflicts = dirEntry.getTreeConflicts();
        if (conflicts.containsKey(victimPath = this.getFile(victimName))) {
            SVNTreeConflictDescription conflict = conflicts.remove(victimPath);
            String conflictData = SVNTreeConflictUtil.getTreeConflictData(conflicts);
            SVNHashMap attributes = new SVNHashMap();
            attributes.put("svn:entry:tree-conflicts", conflictData);
            this.modifyEntry(this.getThisDirName(), attributes, true, false);
            return conflict;
        }
        return null;
    }

    public void setFileExternalLocation(String name, SVNURL url, SVNRevision pegRevision, SVNRevision revision, SVNURL reposRootURL) throws SVNException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (url != null) {
            String reposRootStrURL;
            String strURL = url.toDecodedString();
            String path = strURL.substring((reposRootStrURL = reposRootURL.toDecodedString()).length());
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            attributes.put("svn:entry:file-external-peg-revision", pegRevision);
            attributes.put("svn:entry:file-external-revision", revision);
            attributes.put("svn:entry:file-external-path", path);
        } else {
            attributes.put("svn:entry:file-external-peg-revision", SVNRevision.UNDEFINED);
            attributes.put("svn:entry:file-external-revision", SVNRevision.UNDEFINED);
            attributes.put("svn:entry:file-external-path", null);
        }
        this.modifyEntry(name, attributes, true, false);
    }

    public int getFormatVersion() {
        return 10;
    }

    public void postUpgradeFormat(int format) throws SVNException {
        super.postUpgradeFormat(format);
        try {
            SVNFileUtil.deleteFile(this.getAdminFile("format"));
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
    }

    protected void createFormatFile(File formatFile, boolean createMyself) throws SVNException {
    }

    protected boolean readExtraOptions(BufferedReader reader, SVNEntry entry) throws SVNException, IOException {
        if (super.readExtraOptions(reader, entry)) {
            return true;
        }
        String line = reader.readLine();
        if (this.isEntryFinished(line)) {
            return true;
        }
        String treeConflictData = this.parseString(line);
        if (treeConflictData != null) {
            entry.setTreeConflictData(treeConflictData);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return true;
        }
        String fileExternalData = this.parseString(line);
        if (fileExternalData != null) {
            SVNAdminUtil.unserializeExternalFileData(entry, fileExternalData);
        }
        return false;
    }

    protected int writeExtraOptions(Writer writer, String entryName, SVNEntry entry, int emptyFields) throws SVNException, IOException {
        emptyFields = super.writeExtraOptions(writer, entryName, entry, emptyFields);
        String treeConflictData = entry.getTreeConflictData();
        emptyFields = this.writeString(writer, treeConflictData, emptyFields) ? 0 : ++emptyFields;
        String serializedFileExternalData = SVNAdminUtil.serializeExternalFileData(entry);
        emptyFields = this.writeString(writer, serializedFileExternalData, emptyFields) ? 0 : ++emptyFields;
        return emptyFields;
    }

    protected boolean isEntryPropertyApplicable(String propName) {
        return propName != null;
    }
}

