/*
 * Decompiled with CFR 0.152.
 */
package net.oni2.aeinstaller.updater.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import net.oni2.aeinstaller.updater.backend.Paths;
import net.oni2.platformtools.applicationinvoker.ApplicationInvoker;
import net.oni2.platformtools.applicationinvoker.EExeType;
import net.oni2.platformtools.applicationinvoker.ERuntimeNotInstalledException;
import net.oni2.svnaccess.SVN;
import net.oni2.svnaccess.SVNUpdateListener;

public class MainWin
extends JFrame {
    private static final long serialVersionUID = -3653187495409881426L;
    JLabel step = new JLabel("Preparing");
    JProgressBar bar = new JProgressBar(0, 1);
    JButton closeBtn = new JButton("Close and launch AEI");

    public MainWin() {
        super("AEInstaller2 self updater");
        this.setLayout(new BorderLayout(2, 4));
        this.bar.setPreferredSize(new Dimension(250, 16));
        this.closeBtn.setEnabled(false);
        this.add((Component)this.bar, "Center");
        this.add((Component)this.step, "North");
        this.add((Component)this.closeBtn, "South");
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setLocationRelativeTo(null);
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWin.this.exit();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                if (MainWin.this.closeBtn.isEnabled()) {
                    MainWin.this.exit();
                }
            }
        });
        Updater upd = new Updater();
        upd.execute();
    }

    private void exit() {
        File aei = new File(new File(Paths.getInstallerPath(), "bin"), "AEInstaller2.jar");
        if (aei.exists()) {
            try {
                ApplicationInvoker.execute(EExeType.JAR, null, aei, null, false);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (ERuntimeNotInstalledException e) {
                e.printStackTrace();
            }
        }
        this.dispose();
    }

    class Status {
        public int done;
        public int total;

        public Status(int done, int total) {
            this.done = done;
            this.total = total;
        }
    }

    class Updater
    extends SwingWorker<Status, Status> {
        Updater() {
        }

        @Override
        protected Status doInBackground() throws Exception {
            MainWin.this.step.setText("Waiting for AEI to close");
            int i = 0;
            while (!this.checkWritable() && i < 20) {
                ++i;
                Thread.sleep(500L);
            }
            if (i >= 20) {
                JOptionPane.showMessageDialog(null, "Could not update because the main file of AEI was locked.\nPerhaps you are still running an instance of AEI?", "Could not update!", 0);
                System.exit(1);
                return null;
            }
            MainWin.this.step.setText("Updating");
            SVN svn = new SVN();
            try {
                int x = svn.checkSVN("http://svn.aei.oni2.net", new File(Paths.getPrefsPath(), "bin"));
                if (x != 0) {
                    svn.updateWC("http://svn.aei.oni2.net", new File(Paths.getPrefsPath(), "bin"), new SVNUpdateListener(){

                        @Override
                        public void statusUpdate(int done, int total) {
                            Updater.this.publish(new Status[]{new Status(done, total)});
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        private boolean checkWritable() {
            File aei = new File(new File(Paths.getInstallerPath(), "bin"), "AEInstaller2.jar");
            File temp = new File(new File(Paths.getInstallerPath(), "bin"), "temp.jar");
            if (!aei.exists()) {
                return true;
            }
            if (aei.renameTo(temp)) {
                temp.renameTo(aei);
                return true;
            }
            return false;
        }

        @Override
        protected void process(List<Status> chunks) {
            super.process(chunks);
            if (chunks.size() > 0) {
                Status s = chunks.get(chunks.size() - 1);
                MainWin.this.bar.setValue(s.done);
                MainWin.this.bar.setMaximum(s.total);
            }
        }

        @Override
        protected void done() {
            super.done();
            MainWin.this.step.setText("AEI is up to date");
            MainWin.this.bar.setValue(1);
            MainWin.this.bar.setMaximum(1);
            MainWin.this.closeBtn.setEnabled(true);
        }
    }
}

