/*
 * Decompiled with CFR 0.152.
 */
package net.oni2.platformtools;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import net.oni2.platformtools.applicationinvoker.ApplicationInvocationResult;
import net.oni2.platformtools.applicationinvoker.ApplicationInvoker;
import net.oni2.platformtools.applicationinvoker.EExeType;
import net.oni2.platformtools.applicationinvoker.ERuntimeNotInstalledException;

public class PlatformInformation {
    private static Platform platform = null;
    private static Architecture architecture = null;

    public static Architecture getArchitecture() {
        if (architecture == null) {
            switch (PlatformInformation.getPlatform()) {
                case WIN: {
                    String arch = System.getenv("PROCESSOR_ARCHITECTURE").toLowerCase();
                    if (arch.startsWith("x86")) {
                        architecture = Architecture.X86;
                    }
                    architecture = Architecture.AMD64;
                    break;
                }
                case MACOS: 
                case LINUX: {
                    Vector<String> params = new Vector<String>();
                    params.add("LONG_BIT");
                    ApplicationInvocationResult res = null;
                    try {
                        res = ApplicationInvoker.executeAndWait(EExeType.OSBINARY, null, new File("getconf"), params, false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (ERuntimeNotInstalledException e) {
                        e.printStackTrace();
                    }
                    architecture = Architecture.X86;
                    if (res == null || !res.output.get(0).equals("64")) break;
                    architecture = Architecture.AMD64;
                    break;
                }
                default: {
                    architecture = null;
                }
            }
        }
        return architecture;
    }

    public static Platform getPlatform() {
        if (platform == null) {
            String os = System.getProperty("os.name").toLowerCase();
            platform = os.startsWith("win") ? Platform.WIN : (os.startsWith("linux") ? Platform.LINUX : (os.startsWith("mac") ? Platform.MACOS : Platform.UNKNOWN));
        }
        return platform;
    }

    public static enum Architecture {
        X86,
        AMD64;

    }

    public static enum Platform {
        WIN,
        MACOS,
        LINUX,
        UNKNOWN;

    }
}

