#ifndef UTIL_H
#define UTIL_H

#include <QString>
#include <QMessageBox>
#include <QFileDialog>
#include <QListView>
#include <QTreeView>
#include <QDesktopServices>
#include <QUrl>
#include <QCoreApplication>
#include <QDesktopWidget>

namespace GlobalVars{

const QString AppVersion="0.9b";
const QString OniSplitString="OniSplit.exe";
const QString XmlToolsString="xmlTools.exe";

#ifdef Q_OS_WIN
const QString OniExe="Oni.exe";
#else
const QString OniExe="Oni.app/Contents/MacOS/Oni";
#endif

const QString AppLogName="logVago.txt";
const QString BuiltOniSplitVersion="0.9.96.0";
const QString BuiltXmlToolsVersion="0.8d";
const QString ModsDomain="mods.oni2.net";
#ifdef Q_OS_WIN
const QString VagoNode = "247";
#else
const QString VagoNode = "277";
#endif
const QString VagoCheckUpdatesUrl="http://"+ModsDomain+"/?q=api/node/"+VagoNode+".json";
const QString VagoWebUrl="http://"+ModsDomain+"/node/"+VagoNode;
const QString VagoTemporaryDir=QDir::tempPath()+"/VagoTemp";
const QString HelpDir="help";
const int DefaultWindowWidth=800;
const int DefaultWindowHeight=600;
const char OniSplitProcSeparator=';';
}

/**
  Utilities functions (global)
  **/
namespace Util{
QString normalizePath(QString path);
QString cutName(QString path);
QString insertQuotes(QString path);
QString normalizeAndQuote(QString path);
QString fullTrim(QString str);
QString normalizeDecimalSeparator(QString value);
QString getOSIndependentAppPath();
QString getAppPath();
QString getOniSplitExeName();
QString getXmlToolsExeName();
#ifdef Q_OS_MAC
QString getMonoExecutablePath();
#endif

QStringList multipleDirDialog(QString title);
QStringList substring(QString myString,QString separator,Qt::CaseSensitivity cs = Qt::CaseSensitive);
int indexOfBackward(QString myString, QString toSearch, int from = -1);
bool showQuestionPopUp(QWidget * parent, QString message, QMessageBox::StandardButton standardButton=QMessageBox::NoButton);
bool checkEmptySpaces(QStringList toCheck);
bool checkIfIntegers(QStringList toCheck);
bool checkIfDoubles(QStringList toCheck);
bool isStringInteger(QString myString);
bool isStringDouble(QString myString);
bool copyDir(QString from_dir, QString to_dir, bool replace_on_conflit);
bool rmDir(const QString &dirPath);
QRect getScreenResolution();
void showPopUp(QString message);
void showRichPopUp(QString message);
void showWarningPopUp(QString message);
void showErrorPopUp(QString message);
void showErrorLogPopUp(QString message);
void showRichErrorPopUp(QString message);
void openLogFile();
}
#endif // UTIL_H
