#ifndef CONVERTER_H
#define CONVERTER_H
#include <QProcess>
#include <QProgressBar>
#include <QThread>
#ifdef Q_OS_WIN
#include <QWinTaskbarProgress>
#endif

#include "utilvago.h"

class Converter : public QThread
{
     Q_OBJECT
public:
    Converter(QString AppDir, Logger *myLogger, QStringList *myData);

    #ifdef Q_OS_WIN
    Converter(QString AppDir, Logger *myLogger, QStringList *myData, QWinTaskbarProgress *win7TaskBarProgress);
    #endif
private:
    QString AppDir;
    Logger *myLogger;
    QStringList *myData;
    QProcess *myProcess;
    bool processHasKilled;
    #ifdef Q_OS_WIN
    QWinTaskbarProgress *win7TaskBarProgress = nullptr;
    #endif

protected:
    void run(); //for thread
private slots:
    void terminateCurrProcess();
signals:
    void setupPB(int numberTasks);
    void taskDone();
    void resultConversion(QString result, int numErrors);
    void conversionAborted();
};



#endif // CONVERTER_H
