#include "logger.h"

Logger::Logger(QString appDir, QString logFileName)
{
    myLogFile = std::make_unique<QFile>(appDir+"/"+logFileName);

    if (!myLogFile->open(QIODevice::WriteOnly | QIODevice::Text)){ //open to write
        return;
    }

    logStream = std::make_unique<QTextStream>(myLogFile.get());
    //logStream->setCodec("UTF-8");
}

/**
  ** Mutex makes it thread safe. (not sure if needed although)
  **/
void Logger::writeString(QString strToWrite){
    mutex.lock();
    *this->logStream << "--------------------------------------------";
    *this->logStream << "\nEvent Start: " << QDateTime::currentDateTime().toString("yyyy-MM-dd HH:mm:ss") << "\n" << strToWrite << "\nEvent End.\n";
    *this->logStream << "--------------------------------------------\n";
    this->logStream->flush();
    mutex.unlock();
}

/**
 ** Mutex makes it thread safe. (not sure if needed although)
 **/
void Logger::writeBytes(QByteArray arrToWrite){
    mutex.lock();
    *this->logStream << "--------------------------------------------";
    *this->logStream << "\nEvent Start: " << QDateTime::currentDateTime().toString("yyyy-MM-dd HH:mm:ss") << "\n" << arrToWrite << "\nEvent End.\n";
    *this->logStream << "--------------------------------------------";
    this->logStream->flush();
    mutex.unlock();
}

Logger::~Logger(){

}
